/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search;

import java.util.Map;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.protobufs.BoundaryScanner;
import org.opensearch.protobufs.BuiltinHighlighterType;
import org.opensearch.protobufs.Highlight;
import org.opensearch.protobufs.HighlightField;
import org.opensearch.protobufs.HighlighterEncoder;
import org.opensearch.protobufs.HighlighterFragmenter;
import org.opensearch.protobufs.HighlighterOrder;
import org.opensearch.protobufs.HighlighterTagsSchema;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.transport.grpc.proto.request.common.ObjectMapProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;
import org.opensearch.transport.grpc.util.ProtobufEnumUtils;

class HighlightBuilderProtoUtils {
    private HighlightBuilderProtoUtils() {
    }

    static HighlightBuilder fromProto(Highlight highlightProto, QueryBuilderProtoConverterRegistry registry) {
        int i;
        if (highlightProto == null) {
            throw new IllegalArgumentException("Highlight cannot be null");
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        if (highlightProto.getPreTagsCount() > 0) {
            String[] preTags = new String[highlightProto.getPreTagsCount()];
            for (i = 0; i < highlightProto.getPreTagsCount(); ++i) {
                preTags[i] = highlightProto.getPreTags(i);
            }
            highlightBuilder.preTags(preTags);
        }
        if (highlightProto.getPostTagsCount() > 0) {
            String[] postTags = new String[highlightProto.getPostTagsCount()];
            for (i = 0; i < highlightProto.getPostTagsCount(); ++i) {
                postTags[i] = highlightProto.getPostTags(i);
            }
            highlightBuilder.postTags(postTags);
        }
        if (highlightProto.hasOrder() && highlightProto.getOrder() == HighlighterOrder.HIGHLIGHTER_ORDER_SCORE) {
            highlightBuilder.order(HighlightBuilder.Order.SCORE);
        }
        if (highlightProto.hasHighlightFilter()) {
            highlightBuilder.highlightFilter(Boolean.valueOf(highlightProto.getHighlightFilter()));
        }
        if (highlightProto.hasFragmentSize()) {
            highlightBuilder.fragmentSize(Integer.valueOf(highlightProto.getFragmentSize()));
        }
        if (highlightProto.hasNumberOfFragments()) {
            highlightBuilder.numOfFragments(Integer.valueOf(highlightProto.getNumberOfFragments()));
        }
        if (highlightProto.hasRequireFieldMatch()) {
            highlightBuilder.requireFieldMatch(Boolean.valueOf(highlightProto.getRequireFieldMatch()));
        }
        if (highlightProto.hasBoundaryScanner() && highlightProto.getBoundaryScanner() != BoundaryScanner.BOUNDARY_SCANNER_UNSPECIFIED) {
            HighlightBuilder.BoundaryScannerType boundaryScanner = HighlightBuilderProtoUtils.parseBoundaryScanner(highlightProto.getBoundaryScanner());
            highlightBuilder.boundaryScannerType(boundaryScanner);
        }
        if (highlightProto.hasBoundaryMaxScan()) {
            highlightBuilder.boundaryMaxScan(Integer.valueOf(highlightProto.getBoundaryMaxScan()));
        }
        if (highlightProto.hasBoundaryChars()) {
            highlightBuilder.boundaryChars(highlightProto.getBoundaryChars().toCharArray());
        }
        if (highlightProto.hasBoundaryScannerLocale()) {
            highlightBuilder.boundaryScannerLocale(highlightProto.getBoundaryScannerLocale());
        }
        if (highlightProto.hasType()) {
            if (highlightProto.getType().hasBuiltin() && highlightProto.getType().getBuiltin() != BuiltinHighlighterType.BUILTIN_HIGHLIGHTER_TYPE_UNSPECIFIED) {
                highlightBuilder.highlighterType(ProtobufEnumUtils.convertToString(highlightProto.getType().getBuiltin()));
            } else if (highlightProto.getType().hasCustom()) {
                highlightBuilder.highlighterType(highlightProto.getType().getCustom());
            }
        }
        if (highlightProto.hasFragmenter() && highlightProto.getFragmenter() != HighlighterFragmenter.HIGHLIGHTER_FRAGMENTER_UNSPECIFIED) {
            highlightBuilder.fragmenter(ProtobufEnumUtils.convertToString(highlightProto.getFragmenter()));
        }
        if (highlightProto.hasNoMatchSize()) {
            highlightBuilder.noMatchSize(Integer.valueOf(highlightProto.getNoMatchSize()));
        }
        if (highlightProto.hasForceSource()) {
            highlightBuilder.forceSource(Boolean.valueOf(highlightProto.getForceSource()));
        }
        if (highlightProto.hasPhraseLimit()) {
            highlightBuilder.phraseLimit(Integer.valueOf(highlightProto.getPhraseLimit()));
        }
        if (highlightProto.hasMaxAnalyzerOffset()) {
            highlightBuilder.maxAnalyzerOffset(Integer.valueOf(highlightProto.getMaxAnalyzerOffset()));
        }
        if (highlightProto.hasOptions()) {
            highlightBuilder.options(ObjectMapProtoUtils.fromProto(highlightProto.getOptions()));
        }
        if (highlightProto.hasHighlightQuery()) {
            if (registry == null) {
                throw new IllegalStateException("QueryBuilderProtoConverterRegistry cannot be null.");
            }
            QueryBuilder query = registry.fromProto(highlightProto.getHighlightQuery());
            highlightBuilder.highlightQuery(query);
        }
        if (highlightProto.hasTagsSchema() && highlightProto.getTagsSchema() != HighlighterTagsSchema.HIGHLIGHTER_TAGS_SCHEMA_UNSPECIFIED) {
            highlightBuilder.tagsSchema(ProtobufEnumUtils.convertToString(highlightProto.getTagsSchema()));
        }
        if (highlightProto.hasEncoder() && highlightProto.getEncoder() != HighlighterEncoder.HIGHLIGHTER_ENCODER_UNSPECIFIED) {
            highlightBuilder.encoder(ProtobufEnumUtils.convertToString(highlightProto.getEncoder()));
        }
        if (highlightProto.getFieldsCount() > 0) {
            for (Map.Entry entry : highlightProto.getFieldsMap().entrySet()) {
                int j;
                String fieldName = (String)entry.getKey();
                HighlightField fieldProto = (HighlightField)entry.getValue();
                HighlightBuilder.Field fieldBuilder = new HighlightBuilder.Field(fieldName);
                if (fieldProto.hasFragmentOffset()) {
                    fieldBuilder.fragmentOffset(fieldProto.getFragmentOffset());
                }
                if (fieldProto.getMatchedFieldsCount() > 0) {
                    String[] matchedFields = new String[fieldProto.getMatchedFieldsCount()];
                    for (j = 0; j < fieldProto.getMatchedFieldsCount(); ++j) {
                        matchedFields[j] = fieldProto.getMatchedFields(j);
                    }
                    fieldBuilder.matchedFields(matchedFields);
                }
                if (fieldProto.getPreTagsCount() > 0) {
                    String[] preTags = new String[fieldProto.getPreTagsCount()];
                    for (j = 0; j < fieldProto.getPreTagsCount(); ++j) {
                        preTags[j] = fieldProto.getPreTags(j);
                    }
                    fieldBuilder.preTags(preTags);
                }
                if (fieldProto.getPostTagsCount() > 0) {
                    String[] postTags = new String[fieldProto.getPostTagsCount()];
                    for (j = 0; j < fieldProto.getPostTagsCount(); ++j) {
                        postTags[j] = fieldProto.getPostTags(j);
                    }
                    fieldBuilder.postTags(postTags);
                }
                if (fieldProto.hasType()) {
                    if (fieldProto.getType().hasBuiltin() && fieldProto.getType().getBuiltin() != BuiltinHighlighterType.BUILTIN_HIGHLIGHTER_TYPE_UNSPECIFIED) {
                        fieldBuilder.highlighterType(ProtobufEnumUtils.convertToString(fieldProto.getType().getBuiltin()));
                    } else if (fieldProto.getType().hasCustom()) {
                        fieldBuilder.highlighterType(fieldProto.getType().getCustom());
                    }
                }
                if (fieldProto.hasBoundaryChars()) {
                    fieldBuilder.boundaryChars(fieldProto.getBoundaryChars().toCharArray());
                }
                if (fieldProto.hasBoundaryMaxScan()) {
                    fieldBuilder.boundaryMaxScan(Integer.valueOf(fieldProto.getBoundaryMaxScan()));
                }
                if (fieldProto.hasBoundaryScanner() && fieldProto.getBoundaryScanner() != BoundaryScanner.BOUNDARY_SCANNER_UNSPECIFIED) {
                    HighlightBuilder.BoundaryScannerType boundaryScanner = HighlightBuilderProtoUtils.parseBoundaryScanner(fieldProto.getBoundaryScanner());
                    fieldBuilder.boundaryScannerType(boundaryScanner);
                }
                if (fieldProto.hasBoundaryScannerLocale()) {
                    fieldBuilder.boundaryScannerLocale(fieldProto.getBoundaryScannerLocale());
                }
                if (fieldProto.hasFragmenter() && fieldProto.getFragmenter() != HighlighterFragmenter.HIGHLIGHTER_FRAGMENTER_UNSPECIFIED) {
                    fieldBuilder.fragmenter(ProtobufEnumUtils.convertToString(fieldProto.getFragmenter()));
                }
                if (fieldProto.hasFragmentSize()) {
                    fieldBuilder.fragmentSize(Integer.valueOf(fieldProto.getFragmentSize()));
                }
                if (fieldProto.hasHighlightFilter()) {
                    fieldBuilder.highlightFilter(Boolean.valueOf(fieldProto.getHighlightFilter()));
                }
                if (fieldProto.hasHighlightQuery()) {
                    if (registry == null) {
                        throw new IllegalStateException("QueryBuilderProtoConverterRegistry cannot be null.");
                    }
                    QueryBuilder query = registry.fromProto(fieldProto.getHighlightQuery());
                    fieldBuilder.highlightQuery(query);
                }
                if (fieldProto.hasNoMatchSize()) {
                    fieldBuilder.noMatchSize(Integer.valueOf(fieldProto.getNoMatchSize()));
                }
                if (fieldProto.hasNumberOfFragments()) {
                    fieldBuilder.numOfFragments(Integer.valueOf(fieldProto.getNumberOfFragments()));
                }
                if (fieldProto.hasOptions()) {
                    fieldBuilder.options(ObjectMapProtoUtils.fromProto(fieldProto.getOptions()));
                }
                if (fieldProto.hasMaxAnalyzerOffset()) {
                    fieldBuilder.maxAnalyzerOffset(Integer.valueOf(fieldProto.getMaxAnalyzerOffset()));
                }
                if (fieldProto.hasForceSource()) {
                    fieldBuilder.forceSource(Boolean.valueOf(fieldProto.getForceSource()));
                }
                highlightBuilder.field(fieldBuilder);
            }
        }
        return highlightBuilder;
    }

    private static HighlightBuilder.BoundaryScannerType parseBoundaryScanner(BoundaryScanner boundaryScanner) {
        switch (boundaryScanner) {
            case BOUNDARY_SCANNER_CHARS: {
                return HighlightBuilder.BoundaryScannerType.CHARS;
            }
            case BOUNDARY_SCANNER_WORD: {
                return HighlightBuilder.BoundaryScannerType.WORD;
            }
            case BOUNDARY_SCANNER_SENTENCE: {
                return HighlightBuilder.BoundaryScannerType.SENTENCE;
            }
        }
        throw new IllegalArgumentException("Unknown BoundaryScanner value: " + String.valueOf(boundaryScanner));
    }
}

