/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.concurrent.Executor;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.BaseMatcher;
import org.eclipse.californium.core.network.EndpointReceiver;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.KeyMID;
import org.eclipse.californium.core.network.KeyToken;
import org.eclipse.californium.core.network.MessageExchangeStore;
import org.eclipse.californium.core.network.RemoveHandler;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObservationStore;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpMatcher
extends BaseMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpMatcher.class);
    private final RemoveHandler exchangeRemoveHandler = new RemoveHandlerImpl();
    private final EndpointContextMatcher endpointContextMatcher;

    public TcpMatcher(NetworkConfig config, NotificationListener notificationListener, TokenGenerator tokenGenerator, ObservationStore observationStore, MessageExchangeStore exchangeStore, Executor executor, EndpointContextMatcher endpointContextMatcher) {
        super(config, notificationListener, tokenGenerator, observationStore, exchangeStore, executor);
        this.endpointContextMatcher = endpointContextMatcher;
    }

    @Override
    public void sendRequest(Exchange exchange) {
        Request request = exchange.getCurrentRequest();
        if (request.isObserve()) {
            this.registerObserve(request);
        }
        exchange.setRemoveHandler(this.exchangeRemoveHandler);
        this.exchangeStore.registerOutboundRequestWithTokenOnly(exchange);
        LOGGER.debug("tracking open request using [{}]", (Object)exchange.getKeyToken());
    }

    @Override
    public void sendResponse(Exchange exchange) {
        Response response = exchange.getCurrentResponse();
        final ObserveRelation observeRelation = exchange.getRelation();
        response.ensureToken(exchange.getCurrentRequest().getToken());
        if (observeRelation != null) {
            response.addMessageObserver(new MessageObserverAdapter(){

                @Override
                public void onSendError(Throwable error) {
                    observeRelation.cancel();
                }
            });
        }
        exchange.setComplete();
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (!message.isConfirmable()) {
            throw new UnsupportedOperationException("sending empty message (ACK/RST) over tcp is not supported!");
        }
        message.setToken(Token.EMPTY);
    }

    @Override
    public void receiveRequest(final Request request, final EndpointReceiver receiver) {
        final Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE, this.executor);
        exchange.setRemoveHandler(this.exchangeRemoveHandler);
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                receiver.receiveRequest(exchange, request);
            }
        });
    }

    @Override
    public void receiveResponse(final Response response, final EndpointReceiver receiver) {
        Object peer = this.endpointContextMatcher.getEndpointIdentity(response.getSourceContext());
        final KeyToken idByToken = this.tokenGenerator.getKeyToken(response.getToken(), peer);
        Exchange tempExchange = this.exchangeStore.get(idByToken);
        if (tempExchange == null) {
            tempExchange = this.matchNotifyResponse(response);
        }
        if (tempExchange == null) {
            LOGGER.trace("discarding by [{}] unmatchable response from [{}]: {}", new Object[]{idByToken, response.getSourceContext(), response});
            this.cancel(response, receiver);
            return;
        }
        final Exchange exchange = tempExchange;
        exchange.execute(new Runnable(){

            @Override
            public void run() {
                boolean checkResponseToken;
                boolean bl = checkResponseToken = !exchange.isNotification() || exchange.getRequest() != exchange.getCurrentRequest();
                if (checkResponseToken && TcpMatcher.this.exchangeStore.get(idByToken) != exchange) {
                    if (TcpMatcher.this.running) {
                        LOGGER.debug("ignoring response {}, exchange not longer matching!", (Object)response);
                    }
                    TcpMatcher.this.cancel(response, receiver);
                    return;
                }
                EndpointContext context = exchange.getEndpointContext();
                if (context == null) {
                    LOGGER.error("ignoring response from [{}]: {}, request pending to sent!", (Object)response.getSourceContext(), (Object)response);
                    TcpMatcher.this.cancel(response, receiver);
                    return;
                }
                try {
                    if (TcpMatcher.this.endpointContextMatcher.isResponseRelatedToRequest(context, response.getSourceContext())) {
                        Request currentRequest = exchange.getCurrentRequest();
                        if (exchange.isNotification() && response.isNotification() && currentRequest.isObserveCancel()) {
                            LOGGER.debug("ignoring notify for pending cancel {}!", (Object)response);
                            TcpMatcher.this.cancel(response, receiver);
                            return;
                        }
                        receiver.receiveResponse(exchange, response);
                        return;
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("ignoring potentially forged response from [{}]: {} for {} with non-matching endpoint context", new Object[]{TcpMatcher.this.endpointContextMatcher.toRelevantState(response.getSourceContext()), response, exchange});
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("error receiving response from [{}]: {} for {}", new Object[]{response.getSourceContext(), response, exchange, ex});
                }
                TcpMatcher.this.cancel(response, receiver);
            }
        });
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message, EndpointReceiver receiver) {
    }

    private void cancel(Response response, EndpointReceiver receiver) {
        response.setCanceled(true);
        receiver.receiveResponse(null, response);
    }

    private class RemoveHandlerImpl
    implements RemoveHandler {
        private RemoveHandlerImpl() {
        }

        @Override
        public void remove(Exchange exchange, KeyToken keyToken, KeyMID keyMID) {
            if (keyToken != null) {
                TcpMatcher.this.exchangeStore.remove(keyToken, exchange);
            }
        }
    }
}

