/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal.handler;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.handler.ConditionHandler;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.automation.module.script.internal.handler.AbstractScriptModuleHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ScriptConditionHandler
extends AbstractScriptModuleHandler<Condition>
implements ConditionHandler {
    public static final String TYPE_ID = "script.ScriptCondition";
    private final Logger logger = LoggerFactory.getLogger(ScriptConditionHandler.class);

    public ScriptConditionHandler(Condition module, String ruleUID, ScriptEngineManager scriptEngineManager) {
        super(module, ruleUID, scriptEngineManager);
    }

    public void compile() throws ScriptException {
        super.compileScript();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSatisfied(Map<String, Object> context) {
        boolean result = false;
        if (this.script.isEmpty()) {
            return true;
        }
        Optional<ScriptEngine> engine = this.getScriptEngine();
        if (engine.isPresent()) {
            Object object;
            ScriptEngine scriptEngine = engine.get();
            try {
                object = scriptEngine;
                if (object instanceof Lock) {
                    void lock;
                    Lock lock2 = (Lock)object;
                    Lock cfr_ignored_0 = (Lock)object;
                    if (!lock.tryLock(1L, TimeUnit.MINUTES)) {
                        this.logger.error("Failed to acquire lock within one minute for script module '{}' of rule with UID '{}'", (Object)((Condition)this.module).getId(), (Object)this.ruleUID);
                        return result;
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try {
                Object returnVal;
                this.setExecutionContext(scriptEngine, context);
                Object object2 = returnVal = this.eval(scriptEngine);
                if (object2 instanceof Boolean) {
                    void boolean1;
                    object = (Boolean)object2;
                    Boolean cfr_ignored_1 = (Boolean)object2;
                    result = boolean1.booleanValue();
                } else {
                    this.logger.error("Script of rule with UID '{}' did not return a boolean value, but '{}'", (Object)this.ruleUID, returnVal);
                }
                this.resetExecutionContext(scriptEngine, context);
            }
            finally {
                ScriptEngine scriptEngine2 = scriptEngine;
                if (scriptEngine2 instanceof Lock) {
                    Lock lock = (Lock)((Object)scriptEngine2);
                    Lock cfr_ignored_2 = (Lock)((Object)scriptEngine2);
                    lock.unlock();
                }
            }
        }
        return result;
    }
}

