/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.error.ConstructorInvoker;
import org.assertj.core.error.DescriptionFormatter;
import org.assertj.core.error.MessageFormatter;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class ShouldBeEqual
implements AssertionErrorFactory {
    private static final String EXPECTED_BUT_WAS_MESSAGE = "%nexpected: %s%n but was: %s";
    private static final String EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR = "%nexpected: %s%n but was: %s%n%s";
    private static final Class<?>[] MSG_ARG_TYPES = Arrays.array(String.class, String.class, String.class);
    private static final Class<?>[] MSG_ARG_TYPES_FOR_ASSERTION_FAILED_ERROR = Arrays.array(String.class, Object.class, Object.class);
    protected final Object actual;
    protected final Object expected;
    protected final MessageFormatter messageFormatter = MessageFormatter.instance();
    protected final ComparisonStrategy comparisonStrategy;
    private Representation representation;
    @VisibleForTesting
    ConstructorInvoker constructorInvoker = new ConstructorInvoker();
    @VisibleForTesting
    DescriptionFormatter descriptionFormatter = DescriptionFormatter.instance();

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, Representation representation) {
        return new ShouldBeEqual(actual, expected, StandardComparisonStrategy.instance(), representation);
    }

    public static AssertionErrorFactory shouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Representation representation) {
        return new ShouldBeEqual(actual, expected, comparisonStrategy, representation);
    }

    protected ShouldBeEqual(Object actual, Object expected, ComparisonStrategy comparisonStrategy, Representation representation) {
        this.actual = actual;
        this.expected = expected;
        this.comparisonStrategy = comparisonStrategy;
        this.representation = representation;
    }

    @Override
    public AssertionError newAssertionError(Description description, Representation representation) {
        AssertionError assertionFailedError;
        String message = this.smartErrorMessage(description, representation);
        if (this.comparisonStrategy.isStandard() && !this.actualAndExpectedHaveSameStringRepresentation()) {
            assertionFailedError = this.assertionFailedError(message, representation);
            if (assertionFailedError != null) {
                return assertionFailedError;
            }
            AssertionError error = this.comparisonFailure(description);
            if (error != null) {
                return error;
            }
        }
        if ((assertionFailedError = this.assertionFailedError(message, representation)) != null) {
            return assertionFailedError;
        }
        return Failures.instance().failure(message);
    }

    protected boolean actualAndExpectedHaveSameStringRepresentation() {
        return java.util.Objects.equals(this.representation.toStringOf(this.actual), this.representation.toStringOf(this.expected));
    }

    protected String smartErrorMessage(Description description, Representation representation) {
        String expectedRepresentation;
        if (this.actualAndExpectedHaveSameStringRepresentation()) {
            return this.defaultDetailedErrorMessage(description, representation);
        }
        String actualRepresentation = representation.toStringOf(this.actual);
        if (this.hasMultilineValue(actualRepresentation, expectedRepresentation = representation.toStringOf(this.expected))) {
            return this.errorMessageForMultilineValues(description, representation, actualRepresentation, expectedRepresentation);
        }
        return this.comparisonStrategy.isStandard() ? this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE, this.expected, this.actual) : this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.expected, this.actual, this.comparisonStrategy);
    }

    private String errorMessageForMultilineValues(Description description, Representation representation, String actualRepresentation, String expectedRepresentation) {
        String desc = DescriptionFormatter.instance().format(description);
        return desc + this.messageForMultilineValues(actualRepresentation, expectedRepresentation, representation);
    }

    private boolean hasMultilineValue(String actualRepresentation, String expectedRepresentation) {
        return actualRepresentation != null && actualRepresentation.contains(System.lineSeparator()) || expectedRepresentation != null && expectedRepresentation.contains(System.lineSeparator());
    }

    private String messageForMultilineValues(String actualRepresentation, String expectedRepresentation, Representation representation) {
        return this.comparisonStrategy.isStandard() ? String.format(EXPECTED_BUT_WAS_MESSAGE, this.indent(expectedRepresentation), this.indent(actualRepresentation)) : String.format(EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, this.indent(expectedRepresentation), this.indent(actualRepresentation), this.comparisonStrategy.asText());
    }

    protected String indent(String valueRepresentation) {
        return String.format("%n%s", valueRepresentation).replace(System.lineSeparator(), System.lineSeparator() + "  ");
    }

    protected String defaultDetailedErrorMessage(Description description, Representation representation) {
        String expectedRepresentation;
        String actualRepresentation = this.detailedActual();
        if (this.hasMultilineValue(actualRepresentation, expectedRepresentation = this.detailedExpected())) {
            return this.errorMessageForMultilineValues(description, representation, actualRepresentation, expectedRepresentation);
        }
        return this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy ? this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE_USING_COMPARATOR, expectedRepresentation, actualRepresentation, this.comparisonStrategy) : this.messageFormatter.format(description, representation, EXPECTED_BUT_WAS_MESSAGE, expectedRepresentation, actualRepresentation);
    }

    private AssertionError assertionFailedError(String message, Representation representation) {
        try {
            Object o = this.constructorInvoker.newInstance("org.opentest4j.AssertionFailedError", MSG_ARG_TYPES_FOR_ASSERTION_FAILED_ERROR, message, representation.toStringOf(this.expected), representation.toStringOf(this.actual));
            if (o instanceof AssertionError) {
                AssertionError assertionError = (AssertionError)o;
                Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(assertionError);
                return assertionError;
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private AssertionError comparisonFailure(Description description) {
        try {
            AssertionError comparisonFailure = this.newComparisonFailure(this.descriptionFormatter.format(description).trim());
            Failures.instance().removeAssertJRelatedElementsFromStackTraceIfNeeded(comparisonFailure);
            return comparisonFailure;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private AssertionError newComparisonFailure(String description) throws Exception {
        Object o = this.constructorInvoker.newInstance("org.junit.ComparisonFailure", MSG_ARG_TYPES, description, this.representation.toStringOf(this.expected), this.representation.toStringOf(this.actual));
        return o instanceof AssertionError ? (AssertionError)o : null;
    }

    protected String detailedActual() {
        return this.representation.unambiguousToStringOf(this.actual);
    }

    protected String detailedExpected() {
        return this.representation.unambiguousToStringOf(this.expected);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ShouldBeEqual other = (ShouldBeEqual)o;
        if (!java.util.Objects.deepEquals(this.actual, other.actual)) {
            return false;
        }
        return java.util.Objects.deepEquals(this.expected, other.expected);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.actual);
        result = 31 * result + Objects.hashCodeFor(this.expected);
        return result;
    }
}

