/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class StopTransServlet
extends HttpServlet {
    private static final long serialVersionUID = 3634806745372015720L;
    public static final String CONTEXT_PATH = "/kettle/stopTrans";
    private static LogWriter log = LogWriter.getInstance();
    private TransformationMap transformationMap;

    public StopTransServlet(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContextPath().equals(CONTEXT_PATH)) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("StopTransServlet.StopOfTransRequested"), new Object[0]);
        }
        String transName = request.getParameter("name");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        try {
            if (useXML) {
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
            } else {
                response.setContentType("text/html");
                out.println("<HTML>");
                out.println("<HEAD>");
                out.println("<TITLE>" + Messages.getString("StopTransServlet.StopTrans") + "</TITLE>");
                out.println("<META http-equiv=\"Refresh\" content=\"2;url=/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">");
                out.println("</HEAD>");
                out.println("<BODY>");
            }
            Trans trans = this.transformationMap.getTransformation(transName);
            if (trans != null) {
                trans.stopAll();
                String message = Messages.getString("StopTransServlet.TransSopRequested", transName);
                if (useXML) {
                    out.println(new WebResult("OK", message).getXML());
                } else {
                    out.println("<H1>" + message + "</H1>");
                    out.println("<a href=\"/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">" + Messages.getString("TransStatusServlet.BackToTransStatusPage") + "</a><p>");
                }
            } else {
                String message = Messages.getString("StopTransServlet.CanNotFindTrans", transName);
                if (useXML) {
                    out.println(new WebResult("ERROR", message).getXML());
                } else {
                    out.println("<H1>" + message + "</H1>");
                    out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
                }
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)).getXML());
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Stop transformation";
    }
}

