/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.search.provider.SearchFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class SearchRoot {
    private List<SearchFilter> filters;
    private FileObject rootFile;
    private URI rootUri;
    private static final List<SearchFilter> EMPTY_FILTER_LIST = Collections.emptyList();
    private static final Logger LOG = Logger.getLogger(SearchRoot.class.getName());

    public SearchRoot(@NonNull FileObject fileObject, @NullAllowed List<SearchFilter> list) {
        Parameters.notNull((CharSequence)"rootFile", (Object)fileObject);
        this.rootFile = fileObject;
        this.filters = list == null ? EMPTY_FILTER_LIST : list;
    }

    public SearchRoot(@NonNull URI uRI, @NullAllowed List<SearchFilter> list) {
        Parameters.notNull((CharSequence)"rootFile", (Object)this.rootFile);
        this.rootUri = uRI;
        this.filters = list == null ? EMPTY_FILTER_LIST : list;
    }

    @NonNull
    public List<SearchFilter> getFilters() {
        return this.filters;
    }

    @NonNull
    public FileObject getFileObject() {
        if (this.rootFile == null) {
            try {
                FileObject fileObject = FileUtil.toFileObject((File)new File(this.rootUri));
                this.rootFile = fileObject == null ? this.createFakeFile(this.rootUri, null) : fileObject;
            }
            catch (Exception exception) {
                this.rootFile = this.createFakeFile(this.rootUri, exception);
            }
        }
        return this.rootFile;
    }

    @NonNull
    public URI getUri() {
        if (this.rootUri == null) {
            this.rootUri = this.rootFile.toURI();
        }
        return this.rootUri;
    }

    private FileObject createFakeFile(URI uRI, Throwable throwable) {
        LOG.log(Level.INFO, "Invalid URI: " + uRI, throwable);
        return FileUtil.createMemoryFileSystem().getRoot();
    }
}

