/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress.aggregate;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.progress.module.LoggingUtils;

public final class ProgressContributor {
    private static final Logger LOG = Logger.getLogger(ProgressContributor.class.getName());
    private String id;
    private int workunits;
    private int current;
    private int parentUnits;
    private int lastParentedUnit;
    private AggregateProgressHandle parent;

    ProgressContributor(String string) {
        this.id = string;
        this.workunits = 0;
        this.current = 0;
        this.lastParentedUnit = 0;
    }

    public String getTrackingId() {
        return this.id;
    }

    void setParent(AggregateProgressHandle aggregateProgressHandle) {
        this.parent = aggregateProgressHandle;
    }

    int getWorkUnits() {
        return this.workunits;
    }

    int getRemainingParentWorkUnits() {
        return this.parentUnits;
    }

    void setAvailableParentWorkUnits(int n) {
        this.parentUnits = n;
    }

    double getCompletedRatio() {
        return this.workunits == 0 ? 0.0 : (double)(this.current / this.workunits);
    }

    public void start(int n) {
        if (this.parent == null) {
            return;
        }
        this.workunits = n;
        this.parent.processContributorStart(this, null);
    }

    public void finish() {
        if (this.parent == null) {
            return;
        }
        if (this.current < this.workunits) {
            this.progress(null, this.workunits);
        }
        this.parent.processContributorFinish(this);
    }

    public void progress(int n) {
        this.progress(null, n);
    }

    public void progress(String string) {
        this.progress(string, this.current);
    }

    public void progress(String string, int n) {
        if (this.parent == null) {
            return;
        }
        if (n < this.current || n > this.workunits) {
            LOG.log(Level.WARNING, "logged ''{0}'' @{1} <{2} or >{3} in {4} at {5}", new Object[]{string, n, this.current, this.workunits, this.parent.displayName, LoggingUtils.findCaller()});
            return;
        }
        if (string != null && n == this.current) {
            this.parent.processContributorStep(this, string, 0);
            return;
        }
        this.current = n;
        int n2 = this.current - this.lastParentedUnit;
        double d = 1.0 / ((double)this.parentUnits / (double)(this.workunits - this.lastParentedUnit));
        if ((double)n2 >= d) {
            boolean bl;
            int n3 = (int)((double)n2 / d);
            boolean bl2 = bl = this.current < 0 || n2 < 0 || n3 < 0;
            if (bl) {
                LOG.log(Level.WARNING, "Progress Contributor before progress: current={0} lastParentedUnit={1}, parentUnits={2}, delta={3}, step={4}", new Object[]{this.current, this.lastParentedUnit, this.parentUnits, n2, d});
            }
            this.lastParentedUnit += (int)((double)n3 * d);
            this.parentUnits -= n3;
            if (bl) {
                LOG.log(Level.WARNING, "Progress Contributor after progress: count={0}, new parentUnits={2}, new lastParentedUnits={1}", new Object[]{n3, this.lastParentedUnit, this.parentUnits});
            }
            this.parent.processContributorStep(this, string, n3);
        }
    }
}

