/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(-1, 73, 89, -1)
 * (ivec4(-64, 72, 88, -76) | abs(~ ivec4(64, 72, 88, 76))) => ivec4(-63, 73, 89, -3)
 * (ivec4(-64, 72, 88, -76) | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(-41, 105, 94, -11)
 * (ivec4(-64, 72, 88, -76) | abs(~ ivec4(24, 40, 23, 64))) => ivec4(-39, 105, 88, -11)
 * (ivec4(64, 72, 88, 76) | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(127, 73, 89, 79)
 * (ivec4(64, 72, 88, 76) | abs(~ ivec4(64, 72, 88, 76))) => ivec4(65, 73, 89, 77)
 * (ivec4(64, 72, 88, 76) | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(87, 105, 94, 77)
 * (ivec4(64, 72, 88, 76) | abs(~ ivec4(24, 40, 23, 64))) => ivec4(89, 105, 88, 77)
 * (ivec4(-24, 40, -23, 64) | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(-1, 105, -7, 75)
 * (ivec4(-24, 40, -23, 64) | abs(~ ivec4(64, 72, 88, 76))) => ivec4(-23, 105, -7, 77)
 * (ivec4(-24, 40, -23, 64) | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(-1, 41, -1, 65)
 * (ivec4(-24, 40, -23, 64) | abs(~ ivec4(24, 40, 23, 64))) => ivec4(-7, 41, -7, 65)
 * (ivec4(24, 40, 23, 64) | abs(~ ivec4(-64, 72, 88, -76))) => ivec4(63, 105, 95, 75)
 * (ivec4(24, 40, 23, 64) | abs(~ ivec4(64, 72, 88, 76))) => ivec4(89, 105, 95, 77)
 * (ivec4(24, 40, 23, 64) | abs(~ ivec4(-24, 40, -23, 64))) => ivec4(31, 41, 23, 65)
 * (ivec4(24, 40, 23, 64) | abs(~ ivec4(24, 40, 23, 64))) => ivec4(25, 41, 31, 65)
 */
#version 150

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) | abs(~ ivec4(-64, 72, 88, -76))), ivec4(-1, 73, 89, -1))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) | abs(~ ivec4(64, 72, 88, 76))), ivec4(-63, 73, 89, -3))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) | abs(~ ivec4(-24, 40, -23, 64))), ivec4(-41, 105, 94, -11))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) | abs(~ ivec4(24, 40, 23, 64))), ivec4(-39, 105, 88, -11))) ? 1 : -1] array3;
  float[all(equal((ivec4(64, 72, 88, 76) | abs(~ ivec4(-64, 72, 88, -76))), ivec4(127, 73, 89, 79))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) | abs(~ ivec4(64, 72, 88, 76))), ivec4(65, 73, 89, 77))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) | abs(~ ivec4(-24, 40, -23, 64))), ivec4(87, 105, 94, 77))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) | abs(~ ivec4(24, 40, 23, 64))), ivec4(89, 105, 88, 77))) ? 1 : -1] array7;
  float[all(equal((ivec4(-24, 40, -23, 64) | abs(~ ivec4(-64, 72, 88, -76))), ivec4(-1, 105, -7, 75))) ? 1 : -1] array8;
  float[all(equal((ivec4(-24, 40, -23, 64) | abs(~ ivec4(64, 72, 88, 76))), ivec4(-23, 105, -7, 77))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) | abs(~ ivec4(-24, 40, -23, 64))), ivec4(-1, 41, -1, 65))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) | abs(~ ivec4(24, 40, 23, 64))), ivec4(-7, 41, -7, 65))) ? 1 : -1] array11;
  float[all(equal((ivec4(24, 40, 23, 64) | abs(~ ivec4(-64, 72, 88, -76))), ivec4(63, 105, 95, 75))) ? 1 : -1] array12;
  float[all(equal((ivec4(24, 40, 23, 64) | abs(~ ivec4(64, 72, 88, 76))), ivec4(89, 105, 95, 77))) ? 1 : -1] array13;
  float[all(equal((ivec4(24, 40, 23, 64) | abs(~ ivec4(-24, 40, -23, 64))), ivec4(31, 41, 23, 65))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) | abs(~ ivec4(24, 40, 23, 64))), ivec4(25, 41, 31, 65))) ? 1 : -1] array15;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length());
}
