/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) + 0l) => i64vec4(165l, 133l, 193l, 76l)
 * (i64vec4(165l, 133l, 193l, 76l) + 3l) => i64vec4(168l, 136l, 196l, 79l)
 * (i64vec4(165l, 133l, 193l, 76l) + -1192l) => i64vec4(-1027l, -1059l, -999l, -1116l)
 * (i64vec4(165l, 133l, 193l, 76l) + 1048576l) => i64vec4(1048741l, 1048709l, 1048769l, 1048652l)
 * (i64vec4(165l, 133l, 193l, 76l) + 4251475l) => i64vec4(4251640l, 4251608l, 4251668l, 4251551l)
 * (i64vec4(165l, 133l, 193l, 76l) + 29852643761l) => i64vec4(29852643926l, 29852643894l, 29852643954l, 29852643837l)
 * (i64vec4(165l, 133l, 193l, 76l) + -4398046511104l) => i64vec4(-4398046510939l, -4398046510971l, -4398046510911l, -4398046511028l)
 * (i64vec4(165l, 133l, 193l, 76l) + -3948976685146l) => i64vec4(-3948976684981l, -3948976685013l, -3948976684953l, -3948976685070l)
 * (i64vec4(165l, 133l, 193l, 76l) + -135763469567146206l) => i64vec4(-135763469567146041l, -135763469567146073l, -135763469567146013l, -135763469567146130l)
 * (i64vec4(80l, -15l, -51l, 0l) + 0l) => i64vec4(80l, -15l, -51l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) + 3l) => i64vec4(83l, -12l, -48l, 3l)
 * (i64vec4(80l, -15l, -51l, 0l) + -1192l) => i64vec4(-1112l, -1207l, -1243l, -1192l)
 * (i64vec4(80l, -15l, -51l, 0l) + 1048576l) => i64vec4(1048656l, 1048561l, 1048525l, 1048576l)
 * (i64vec4(80l, -15l, -51l, 0l) + 4251475l) => i64vec4(4251555l, 4251460l, 4251424l, 4251475l)
 * (i64vec4(80l, -15l, -51l, 0l) + 29852643761l) => i64vec4(29852643841l, 29852643746l, 29852643710l, 29852643761l)
 * (i64vec4(80l, -15l, -51l, 0l) + -4398046511104l) => i64vec4(-4398046511024l, -4398046511119l, -4398046511155l, -4398046511104l)
 * (i64vec4(80l, -15l, -51l, 0l) + -3948976685146l) => i64vec4(-3948976685066l, -3948976685161l, -3948976685197l, -3948976685146l)
 * (i64vec4(80l, -15l, -51l, 0l) + -135763469567146206l) => i64vec4(-135763469567146126l, -135763469567146221l, -135763469567146257l, -135763469567146206l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + 0l), i64vec4(165l, 133l, 193l, 76l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + 3l), i64vec4(168l, 136l, 196l, 79l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + -1192l), i64vec4(-1027l, -1059l, -999l, -1116l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + 1048576l), i64vec4(1048741l, 1048709l, 1048769l, 1048652l))) ? 1 : -1] array3;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + 4251475l), i64vec4(4251640l, 4251608l, 4251668l, 4251551l))) ? 1 : -1] array4;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + 29852643761l), i64vec4(29852643926l, 29852643894l, 29852643954l, 29852643837l))) ? 1 : -1] array5;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + -4398046511104l), i64vec4(-4398046510939l, -4398046510971l, -4398046510911l, -4398046511028l))) ? 1 : -1] array6;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + -3948976685146l), i64vec4(-3948976684981l, -3948976685013l, -3948976684953l, -3948976685070l))) ? 1 : -1] array7;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) + -135763469567146206l), i64vec4(-135763469567146041l, -135763469567146073l, -135763469567146013l, -135763469567146130l))) ? 1 : -1] array8;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + 0l), i64vec4(80l, -15l, -51l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + 3l), i64vec4(83l, -12l, -48l, 3l))) ? 1 : -1] array10;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + -1192l), i64vec4(-1112l, -1207l, -1243l, -1192l))) ? 1 : -1] array11;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + 1048576l), i64vec4(1048656l, 1048561l, 1048525l, 1048576l))) ? 1 : -1] array12;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + 4251475l), i64vec4(4251555l, 4251460l, 4251424l, 4251475l))) ? 1 : -1] array13;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + 29852643761l), i64vec4(29852643841l, 29852643746l, 29852643710l, 29852643761l))) ? 1 : -1] array14;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + -4398046511104l), i64vec4(-4398046511024l, -4398046511119l, -4398046511155l, -4398046511104l))) ? 1 : -1] array15;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + -3948976685146l), i64vec4(-3948976685066l, -3948976685161l, -3948976685197l, -3948976685146l))) ? 1 : -1] array16;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) + -135763469567146206l), i64vec4(-135763469567146126l, -135763469567146221l, -135763469567146257l, -135763469567146206l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
