/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.cache;

import lombok.Generated;
import org.opensearch.neuralsearch.sparse.cache.AbstractLruCache;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCache;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCacheItem;
import org.opensearch.neuralsearch.sparse.cache.LruCacheKey;

public class LruDocumentCache
extends AbstractLruCache<DocumentKey> {
    private static final LruDocumentCache INSTANCE = new LruDocumentCache();

    protected LruDocumentCache() {
    }

    public static LruDocumentCache getInstance() {
        return INSTANCE;
    }

    @Override
    protected long doEviction(DocumentKey documentKey) {
        CacheKey cacheKey = documentKey.getCacheKey();
        int docId = documentKey.getDocId();
        ForwardIndexCacheItem forwardIndexCacheItem = (ForwardIndexCacheItem)ForwardIndexCache.getInstance().get(cacheKey);
        if (forwardIndexCacheItem == null) {
            return 0L;
        }
        return forwardIndexCacheItem.getWriter().erase(docId);
    }

    public static final class DocumentKey
    implements LruCacheKey {
        private final CacheKey cacheKey;
        private final int docId;

        @Generated
        public DocumentKey(CacheKey cacheKey, int docId) {
            this.cacheKey = cacheKey;
            this.docId = docId;
        }

        @Override
        @Generated
        public CacheKey getCacheKey() {
            return this.cacheKey;
        }

        @Generated
        public int getDocId() {
            return this.docId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocumentKey)) {
                return false;
            }
            DocumentKey other = (DocumentKey)o;
            if (this.getDocId() != other.getDocId()) {
                return false;
            }
            CacheKey this$cacheKey = this.getCacheKey();
            CacheKey other$cacheKey = other.getCacheKey();
            return !(this$cacheKey == null ? other$cacheKey != null : !((Object)this$cacheKey).equals(other$cacheKey));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getDocId();
            CacheKey $cacheKey = this.getCacheKey();
            result = result * 59 + ($cacheKey == null ? 43 : ((Object)$cacheKey).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LruDocumentCache.DocumentKey(cacheKey=" + String.valueOf(this.getCacheKey()) + ", docId=" + this.getDocId() + ")";
        }
    }
}

