/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.Objects;
import software.amazon.cryptography.materialproviders.model.DerivationAlgorithm;
import software.amazon.cryptography.materialproviders.model.Encrypt;

public class IntermediateKeyWrapping {
    private final DerivationAlgorithm keyEncryptionKeyKdf;
    private final DerivationAlgorithm macKeyKdf;
    private final Encrypt pdkEncryptAlgorithm;

    protected IntermediateKeyWrapping(BuilderImpl builder) {
        this.keyEncryptionKeyKdf = builder.keyEncryptionKeyKdf();
        this.macKeyKdf = builder.macKeyKdf();
        this.pdkEncryptAlgorithm = builder.pdkEncryptAlgorithm();
    }

    public DerivationAlgorithm keyEncryptionKeyKdf() {
        return this.keyEncryptionKeyKdf;
    }

    public DerivationAlgorithm macKeyKdf() {
        return this.macKeyKdf;
    }

    public Encrypt pdkEncryptAlgorithm() {
        return this.pdkEncryptAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected DerivationAlgorithm keyEncryptionKeyKdf;
        protected DerivationAlgorithm macKeyKdf;
        protected Encrypt pdkEncryptAlgorithm;

        protected BuilderImpl() {
        }

        protected BuilderImpl(IntermediateKeyWrapping model) {
            this.keyEncryptionKeyKdf = model.keyEncryptionKeyKdf();
            this.macKeyKdf = model.macKeyKdf();
            this.pdkEncryptAlgorithm = model.pdkEncryptAlgorithm();
        }

        @Override
        public Builder keyEncryptionKeyKdf(DerivationAlgorithm keyEncryptionKeyKdf) {
            this.keyEncryptionKeyKdf = keyEncryptionKeyKdf;
            return this;
        }

        @Override
        public DerivationAlgorithm keyEncryptionKeyKdf() {
            return this.keyEncryptionKeyKdf;
        }

        @Override
        public Builder macKeyKdf(DerivationAlgorithm macKeyKdf) {
            this.macKeyKdf = macKeyKdf;
            return this;
        }

        @Override
        public DerivationAlgorithm macKeyKdf() {
            return this.macKeyKdf;
        }

        @Override
        public Builder pdkEncryptAlgorithm(Encrypt pdkEncryptAlgorithm) {
            this.pdkEncryptAlgorithm = pdkEncryptAlgorithm;
            return this;
        }

        @Override
        public Encrypt pdkEncryptAlgorithm() {
            return this.pdkEncryptAlgorithm;
        }

        @Override
        public IntermediateKeyWrapping build() {
            if (Objects.isNull(this.keyEncryptionKeyKdf())) {
                throw new IllegalArgumentException("Missing value for required field `keyEncryptionKeyKdf`");
            }
            if (Objects.isNull(this.macKeyKdf())) {
                throw new IllegalArgumentException("Missing value for required field `macKeyKdf`");
            }
            if (Objects.isNull(this.pdkEncryptAlgorithm())) {
                throw new IllegalArgumentException("Missing value for required field `pdkEncryptAlgorithm`");
            }
            return new IntermediateKeyWrapping(this);
        }
    }

    public static interface Builder {
        public Builder keyEncryptionKeyKdf(DerivationAlgorithm var1);

        public DerivationAlgorithm keyEncryptionKeyKdf();

        public Builder macKeyKdf(DerivationAlgorithm var1);

        public DerivationAlgorithm macKeyKdf();

        public Builder pdkEncryptAlgorithm(Encrypt var1);

        public Encrypt pdkEncryptAlgorithm();

        public IntermediateKeyWrapping build();
    }
}

