/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.engine;

import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.validation.Issue;
import org.openhab.core.model.script.engine.ScriptError;
import org.openhab.core.model.script.engine.ScriptException;

public class ScriptParsingException
extends ScriptException {
    private static final long serialVersionUID = -3784970293118871807L;

    public ScriptParsingException(String message, String scriptAsString) {
        super(message, scriptAsString);
    }

    public ScriptParsingException(String message, String scriptAsString, Throwable t) {
        super(message, scriptAsString, t);
    }

    public ScriptParsingException addDiagnosticErrors(List<Resource.Diagnostic> errors) {
        for (Resource.Diagnostic emfDiagnosticError : errors) {
            if (emfDiagnosticError instanceof AbstractDiagnostic) {
                AbstractDiagnostic e = (AbstractDiagnostic)emfDiagnosticError;
                this.getErrors().add(new ScriptError(e.getMessage(), e.getLine(), e.getOffset(), e.getLength()));
                continue;
            }
            if (emfDiagnosticError instanceof ExceptionDiagnostic) {
                ExceptionDiagnostic e = (ExceptionDiagnostic)emfDiagnosticError;
                this.getErrors().add(new ScriptError(e.getMessage(), e.getLine(), e.getOffset(), e.getLength()));
                continue;
            }
            this.getErrors().add(new ScriptError(emfDiagnosticError.getMessage(), -1, -1, -1));
        }
        return this;
    }

    public ScriptParsingException addValidationIssues(Iterable<Issue> validationErrors) {
        for (Issue validationError : validationErrors) {
            this.getErrors().add(new ScriptError(validationError.getMessage(), validationError.getLineNumber(), validationError.getOffset(), validationError.getLength()));
        }
        return this;
    }
}

