/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.io;

import com.igormaznitsa.jbbp.exceptions.JBBPReachedArraySizeLimitException;

@FunctionalInterface
public interface JBBPArraySizeLimiter {
    public static final JBBPArraySizeLimiter NO_LIMIT_FOR_ARRAY_SIZE = () -> 0;

    public static boolean isBreakReadWholeStream(int readItems, JBBPArraySizeLimiter limiter) {
        int limit = limiter.getArrayItemsLimit();
        if (limit == 0) {
            return false;
        }
        if (limit > 0) {
            if (readItems > limit) {
                throw new JBBPReachedArraySizeLimitException("Detected too big array during stream rest read: " + readItems, readItems, Math.abs(limit));
            }
            return false;
        }
        return readItems >= Math.abs(limit);
    }

    public int getArrayItemsLimit();
}

