/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common.osgi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class ResourceBundleClassLoader
extends ClassLoader {
    private Bundle bundle;
    private String path;
    private String filePattern;

    public ResourceBundleClassLoader(@Nullable Bundle bundle, @Nullable String path, @Nullable String filePattern) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("The bundle must not be null!");
        }
        this.bundle = bundle;
        this.path = path != null ? path : "/";
        this.filePattern = filePattern != null ? filePattern : "*";
    }

    @Override
    public @Nullable URL getResource(String name) {
        Enumeration resourceFiles = this.bundle.findEntries(this.path, this.filePattern, true);
        LinkedList<URL> allResources = new LinkedList<URL>();
        if (resourceFiles != null) {
            while (resourceFiles.hasMoreElements()) {
                URL resourceURL = (URL)resourceFiles.nextElement();
                String resourcePath = resourceURL.getFile();
                File resourceFile = new File(resourcePath);
                String resourceFileName = resourceFile.getName();
                if (!resourceFileName.equals(name)) continue;
                allResources.add(resourceURL);
            }
        }
        if (allResources.isEmpty()) {
            return null;
        }
        if (allResources.size() == 1) {
            return (URL)allResources.getFirst();
        }
        for (URL url : allResources) {
            boolean isHostResource;
            boolean bl = isHostResource = this.bundle.getEntry(url.getPath()) != null && this.bundle.getEntry(url.getPath()).equals(url);
            if (isHostResource) continue;
            return url;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public @Nullable InputStream getResourceAsStream(String name) {
        URL resourceURL = this.getResource(name);
        if (resourceURL != null) {
            block22: {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream resourceStream = resourceURL.openStream();){
                        ByteArrayInputStream byteArrayInputStream;
                        InputStreamReader resourceReader;
                        Throwable throwable2;
                        block23: {
                            if (resourceStream == null) break block22;
                            throwable2 = null;
                            Object var7_11 = null;
                            resourceReader = new InputStreamReader(resourceStream, StandardCharsets.ISO_8859_1);
                            Properties props = new Properties();
                            props.load(resourceReader);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            props.store(baos, "converted");
                            byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                            if (resourceReader == null) break block23;
                            ((Reader)resourceReader).close();
                        }
                        return byteArrayInputStream;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (resourceReader != null) {
                                        ((Reader)resourceReader).close();
                                    }
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable4;
                                    } else if (throwable2 != throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    throw throwable2;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return super.getResourceAsStream(name);
        }
        return null;
    }
}

