/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.factory;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import gnu.io.factory.SerialPortCreator;
import gnu.io.factory.SerialPortFactory;
import gnu.io.factory.SerialPortRegistry;

public class DefaultSerialPortFactory
implements SerialPortFactory {
    private SerialPortRegistry portRegistry = new SerialPortRegistry();

    @Override
    public <T extends SerialPort> T createSerialPort(String portName, Class<T> expectedClass) throws PortInUseException, NoSuchPortException, UnsupportedCommOperationException {
        SerialPortCreator<T> portCreator = this.portRegistry.getPortCreatorForPortName(portName, expectedClass);
        if (portCreator != null) {
            return portCreator.createPort(portName);
        }
        throw new NoSuchPortException(portName + " can not be opened.");
    }

    @Override
    public SerialPort createSerialPort(String portName) throws PortInUseException, NoSuchPortException, UnsupportedCommOperationException {
        SerialPortCreator<SerialPort> portCreator = this.portRegistry.getPortCreatorForPortName(portName, SerialPort.class);
        if (portCreator != null) {
            return portCreator.createPort(portName);
        }
        throw new NoSuchPortException(portName + " can not be opened.");
    }

    public SerialPortRegistry getPortRegistry() {
        return this.portRegistry;
    }
}

