/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.internal;

import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.internal.SimpleStopWatch;

@NonNullByDefault
public class AggregateStopWatch {
    final String operationId;
    final SimpleStopWatch total = new SimpleStopWatch();
    final SimpleStopWatch connection = new SimpleStopWatch();
    final SimpleStopWatch transaction = new SimpleStopWatch();
    final SimpleStopWatch callback = new SimpleStopWatch();

    public AggregateStopWatch() {
        this.operationId = UUID.randomUUID().toString();
    }

    public void suspendAllRunning() {
        SimpleStopWatch[] simpleStopWatchArray = new SimpleStopWatch[]{this.total, this.connection, this.transaction, this.callback};
        int n = simpleStopWatchArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleStopWatch watch = simpleStopWatchArray[n2];
            if (watch.isRunning()) {
                watch.suspend();
            }
            ++n2;
        }
    }

    public String toString() {
        return String.format("{total: %d ms, connection: %d, transaction=%d, callback=%d}", this.total.getTotalTimeMillis(), this.connection.getTotalTimeMillis(), this.transaction.getTotalTimeMillis(), this.callback.getTotalTimeMillis());
    }
}

