/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.net;

import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.net.SerialConnectionFactory;
import net.wimpi.modbus.util.SerialParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSerialListener {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSerialListener.class);
    private boolean m_Listening;
    private SerialConnection m_SerialCon;
    private static int c_RequestCounter = 0;
    private SerialConnectionFactory m_ConnectionFactory;
    private static final int REQUESTS_TOGC = 15;

    public ModbusSerialListener(SerialParameters params, SerialConnectionFactory connectionFactory) {
        this.m_ConnectionFactory = connectionFactory;
        this.m_SerialCon = this.m_ConnectionFactory.create(params);
        logger.trace("Created connection");
        this.listen();
    }

    public ModbusSerialListener(SerialParameters params) {
        this(params, new SerialConnectionFactoryImpl());
    }

    private void listen() {
        try {
            this.m_Listening = true;
            this.m_SerialCon.open();
            logger.trace("Opened Serial connection.");
            ModbusTransport transport = this.m_SerialCon.getModbusTransport();
            while (true) {
                if (!this.m_Listening) {
                    continue;
                }
                try {
                    ModbusRequest request = transport.readRequest();
                    ModbusResponse response = null;
                    response = ModbusCoupler.getReference().getProcessImage() == null ? request.createExceptionResponse(1) : request.createResponse();
                    logger.debug("Request:{}", (Object)request.getHexMessage());
                    logger.debug("Response:{}", (Object)response.getHexMessage());
                    transport.writeMessage(response);
                    this.count();
                }
                catch (ModbusIOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void setListening(boolean b) {
        this.m_Listening = b;
    }

    public boolean isListening() {
        return this.m_Listening;
    }

    private void count() {
        if (++c_RequestCounter == 15) {
            System.gc();
            c_RequestCounter = 0;
        }
    }

    public static class SerialConnectionFactoryImpl
    implements SerialConnectionFactory {
        @Override
        public SerialConnection create(SerialParameters parameters) {
            return new SerialConnection(parameters);
        }
    }
}

