/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.utils;

import com.igormaznitsa.jbbp.JBBPCustomFieldTypeProcessor;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.io.JBBPBitInputStream;
import com.igormaznitsa.jbbp.io.JBBPBitOrder;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.utils.JBBPUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JBBPCustomFieldTypeProcessorAggregator
implements JBBPCustomFieldTypeProcessor {
    private final Map<String, JBBPCustomFieldTypeProcessor> customTypeMap = new HashMap<String, JBBPCustomFieldTypeProcessor>();
    private final String[] types;

    public JBBPCustomFieldTypeProcessorAggregator(JBBPCustomFieldTypeProcessor ... processors) {
        for (JBBPCustomFieldTypeProcessor p : processors) {
            for (String s : p.getCustomFieldTypes()) {
                JBBPUtils.assertNotNull(s, "Type must not be null");
                if (this.customTypeMap.containsKey(s)) {
                    throw new IllegalArgumentException("Detected duplicated field type [" + s + ']');
                }
                this.customTypeMap.put(s, p);
            }
        }
        this.types = this.customTypeMap.keySet().toArray(new String[this.customTypeMap.size()]);
    }

    @Override
    public String[] getCustomFieldTypes() {
        return this.types;
    }

    @Override
    public boolean isAllowed(JBBPFieldTypeParameterContainer fieldType, String fieldName, int extraData, boolean isArray) {
        return this.customTypeMap.get(fieldType.getTypeName()).isAllowed(fieldType, fieldName, extraData, isArray);
    }

    @Override
    public JBBPAbstractField readCustomFieldType(JBBPBitInputStream in, JBBPBitOrder bitOrder, int parserFlags, JBBPFieldTypeParameterContainer fieldType, JBBPNamedFieldInfo fieldName, int extraData, boolean readWholeStream, int arrayLength) throws IOException {
        return this.customTypeMap.get(fieldType.getTypeName()).readCustomFieldType(in, bitOrder, parserFlags, fieldType, fieldName, extraData, readWholeStream, arrayLength);
    }
}

