/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ECDHClientKeyExchange;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;

@NoPublicAPI
public final class EcdhPskClientKeyExchange
extends ECDHClientKeyExchange {
    private static final int IDENTITY_LENGTH_BITS = 16;
    private final PskPublicInformation identity;

    public EcdhPskClientKeyExchange(PskPublicInformation identity, byte[] encodedPoint, InetSocketAddress peerAddress) {
        super(encodedPoint, peerAddress);
        if (identity == null) {
            throw new NullPointerException("identity cannot be null");
        }
        this.identity = identity;
    }

    @Override
    protected void writeFragment(DatagramWriter writer) {
        writer.write(this.identity.length(), 16);
        writer.writeBytes(this.identity.getBytes());
        super.writeFragment(writer);
    }

    public static HandshakeMessage fromReader(DatagramReader reader, InetSocketAddress peerAddress) {
        if (peerAddress == null) {
            throw new NullPointerException("peer address cannot be null");
        }
        int identityLength = reader.read(16);
        byte[] identityEncoded = reader.readBytes(identityLength);
        PskPublicInformation identity = PskPublicInformation.fromByteArray(identityEncoded);
        byte[] pointEncoded = EcdhPskClientKeyExchange.readEncodedPoint(reader);
        return new EcdhPskClientKeyExchange(identity, pointEncoded, peerAddress);
    }

    @Override
    public int getMessageLength() {
        return 2 + this.identity.length() + super.getMessageLength();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\t Encoded identity value: ");
        sb.append((Object)this.identity).append(StringUtil.lineSeparator());
        sb.append(super.toString());
        sb.append(StringUtil.lineSeparator());
        return sb.toString();
    }

    public PskPublicInformation getIdentity() {
        return this.identity;
    }
}

