/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.compiler.conversion;

import com.igormaznitsa.jbbp.compiler.JBBPCompiledBlock;
import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.compiler.conversion.IntConstValueEvaluator;
import com.igormaznitsa.jbbp.compiler.tokenizer.JBBPFieldTypeParameterContainer;
import com.igormaznitsa.jbbp.compiler.varlen.JBBPIntegerValueEvaluator;
import com.igormaznitsa.jbbp.io.JBBPByteOrder;
import com.igormaznitsa.jbbp.utils.JBBPIntCounter;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public class CompiledBlockVisitor {
    protected final JBBPCompiledBlock compiledBlock;
    protected final int parserFlags;

    public CompiledBlockVisitor(int parserFlags, JBBPCompiledBlock notNullCompiledBlock) {
        this.parserFlags = parserFlags;
        this.compiledBlock = notNullCompiledBlock;
    }

    protected boolean isFlagSkipRemainingFieldsIfEOF() {
        return (this.parserFlags & 1) != 0;
    }

    public final CompiledBlockVisitor visit() {
        this.visitStart();
        byte[] compiledData = this.compiledBlock.getCompiledData();
        JBBPIntCounter positionAtCompiledBlock = new JBBPIntCounter(0);
        int positionAtNamedFieldList = 0;
        int positionAtVarLengthProcessors = 0;
        while (positionAtCompiledBlock.get() < compiledData.length) {
            JBBPIntegerValueEvaluator arraySizeEvaluator;
            int theOffset = positionAtCompiledBlock.get();
            int c = compiledData[positionAtCompiledBlock.getAndIncrement()] & 0xFF;
            boolean wideCode = (c & 0x80) != 0;
            int ec = wideCode ? compiledData[positionAtCompiledBlock.getAndIncrement()] & 0xFF : 0;
            boolean altFileType = (ec & 4) != 0;
            boolean extraFieldNumAsExpr = (ec & 2) != 0;
            int code = ec << 8 | c;
            JBBPNamedFieldInfo name = (code & 0x10) == 0 ? null : this.compiledBlock.getNamedFields()[positionAtNamedFieldList++];
            JBBPByteOrder byteOrder = (code & 0x40) == 0 ? JBBPByteOrder.BIG_ENDIAN : JBBPByteOrder.LITTLE_ENDIAN;
            JBBPIntegerValueEvaluator extraFieldValueEvaluator = extraFieldNumAsExpr ? this.compiledBlock.getArraySizeEvaluators()[positionAtVarLengthProcessors++] : null;
            boolean readWholeStream = false;
            switch (code & 0x120) {
                case 32: {
                    arraySizeEvaluator = new IntConstValueEvaluator(JBBPUtils.unpackInt(compiledData, positionAtCompiledBlock));
                    break;
                }
                case 256: {
                    arraySizeEvaluator = new IntConstValueEvaluator(-1);
                    readWholeStream = true;
                    break;
                }
                case 288: {
                    arraySizeEvaluator = this.compiledBlock.getArraySizeEvaluators()[positionAtVarLengthProcessors++];
                    break;
                }
                default: {
                    arraySizeEvaluator = null;
                }
            }
            int theCode = code & 0xF;
            switch (theCode) {
                case 14: {
                    this.visitActionItem(theOffset, code, null);
                    break;
                }
                case 1: 
                case 12: {
                    JBBPIntegerValueEvaluator evaluator;
                    JBBPIntegerValueEvaluator jBBPIntegerValueEvaluator = evaluator = extraFieldNumAsExpr ? extraFieldValueEvaluator : new IntConstValueEvaluator(JBBPUtils.unpackInt(compiledData, positionAtCompiledBlock));
                    if (altFileType) {
                        if (theCode == 12) {
                            this.visitValField(theOffset, name, evaluator);
                            break;
                        }
                        throw new Error("Unexpected code:" + theCode);
                    }
                    this.visitActionItem(theOffset, theCode, evaluator);
                    break;
                }
                case 2: {
                    JBBPIntegerValueEvaluator numberOfBits = extraFieldNumAsExpr ? extraFieldValueEvaluator : new IntConstValueEvaluator(JBBPUtils.unpackInt(compiledData, positionAtCompiledBlock));
                    this.visitBitField(theOffset, name, numberOfBits, arraySizeEvaluator);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.visitPrimitiveField(theOffset, theCode, name, byteOrder, readWholeStream, altFileType, arraySizeEvaluator);
                    break;
                }
                case 10: {
                    this.visitStructureStart(theOffset, name, arraySizeEvaluator);
                    break;
                }
                case 11: {
                    JBBPUtils.unpackInt(compiledData, positionAtCompiledBlock);
                    this.visitStructureEnd(theOffset, name);
                    break;
                }
                case 13: {
                    JBBPIntegerValueEvaluator extraDataValueEvaluator = extraFieldNumAsExpr ? extraFieldValueEvaluator : new IntConstValueEvaluator(JBBPUtils.unpackInt(compiledData, positionAtCompiledBlock));
                    this.visitVarField(theOffset, name, byteOrder, readWholeStream, arraySizeEvaluator, extraDataValueEvaluator);
                    break;
                }
                case 15: {
                    JBBPIntegerValueEvaluator extraDataValueEvaluator = extraFieldNumAsExpr ? extraFieldValueEvaluator : new IntConstValueEvaluator(JBBPUtils.unpackInt(compiledData, positionAtCompiledBlock));
                    JBBPFieldTypeParameterContainer fieldTypeInfo = this.compiledBlock.getCustomTypeFields()[JBBPUtils.unpackInt(compiledData, positionAtCompiledBlock)];
                    this.visitCustomField(theOffset, fieldTypeInfo, name, byteOrder, readWholeStream, arraySizeEvaluator, extraDataValueEvaluator);
                    break;
                }
                default: {
                    throw new Error("Unexpected code, contact developer!");
                }
            }
        }
        this.visitEnd();
        return this;
    }

    public void visitActionItem(int offsetInCompiledBlock, int actionType, JBBPIntegerValueEvaluator nullableArgument) {
    }

    public void visitValField(int offsetInCompiledBlock, JBBPNamedFieldInfo nameFieldInfo, JBBPIntegerValueEvaluator expression) {
    }

    public void visitPrimitiveField(int offsetInCompiledBlock, int primitiveType, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStreamAsArray, boolean altFieldType, JBBPIntegerValueEvaluator nullableArraySize) {
    }

    public void visitVarField(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStreamIntoArray, JBBPIntegerValueEvaluator nullableArraySize, JBBPIntegerValueEvaluator extraDataValueEvaluator) {
    }

    public void visitCustomField(int offsetInCompiledBlock, JBBPFieldTypeParameterContainer notNullFieldType, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPByteOrder byteOrder, boolean readWholeStream, JBBPIntegerValueEvaluator nullableArraySizeEvaluator, JBBPIntegerValueEvaluator extraDataValueEvaluator) {
    }

    public void visitBitField(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPIntegerValueEvaluator notNullFieldSize, JBBPIntegerValueEvaluator nullableArraySize) {
    }

    public void visitStructureStart(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo, JBBPIntegerValueEvaluator nullableArraySize) {
    }

    public void visitStructureEnd(int offsetInCompiledBlock, JBBPNamedFieldInfo nullableNameFieldInfo) {
    }

    public void visitStart() {
    }

    public void visitEnd() {
    }
}

