/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.glu.tessellation;

import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.glu.tessellation.TessCallback;
import org.lwjgl.test.glu.tessellation.VertexData;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.glu.GLUtessellator;
import org.lwjgl.util.glu.GLUtessellatorCallback;

public class TessellationTest {
    private GLUtessellator tesselator;

    void init() {
        this.tesselator = GLU.gluNewTess();
        TessCallback callback = new TessCallback();
        this.tesselator.gluTessCallback(100101, (GLUtessellatorCallback)callback);
        this.tesselator.gluTessCallback(100100, (GLUtessellatorCallback)callback);
        this.tesselator.gluTessCallback(100102, (GLUtessellatorCallback)callback);
        this.tesselator.gluTessCallback(100105, (GLUtessellatorCallback)callback);
    }

    void setWindingRule(int windingRule) {
        this.tesselator.gluTessProperty(100140, (double)windingRule);
    }

    void renderContour(double[][] obj_data, int num_vertices) {
        for (int x = 0; x < num_vertices; ++x) {
            this.tesselator.gluTessVertex(obj_data[x], 0, (Object)new VertexData(obj_data[x]));
        }
    }

    void beginPolygon() {
        this.tesselator.gluTessBeginPolygon(null);
    }

    void endPolygon() {
        this.tesselator.gluTessEndPolygon();
    }

    void beginContour() {
        this.tesselator.gluTessBeginContour();
    }

    void endContour() {
        this.tesselator.gluTessEndContour();
    }

    void end() {
        this.tesselator.gluDeleteTess();
    }

    private void createDisplay() throws LWJGLException {
        int width = 300;
        int height = 300;
        Display.setDisplayMode((DisplayMode)new DisplayMode(width, height));
        Display.create();
        Display.setVSyncEnabled((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearDepth((double)1.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5888);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)5888);
    }

    private void loop() {
        while (true) {
            this.render();
            Display.update();
            Display.sync((int)100);
            if (!Display.isCloseRequested()) continue;
            System.exit(0);
        }
    }

    private void render() {
        GL11.glTranslatef((float)150.0f, (float)125.0f, (float)0.0f);
        GL11.glScalef((float)50.0f, (float)50.0f, (float)1.0f);
        double[][] star = new double[][]{{0.6f, -0.1f, 0.0, 1.0, 1.0, 1.0}, {1.35f, 1.4f, 0.0, 1.0, 1.0, 1.0}, {2.1f, -0.1f, 0.0, 1.0, 1.0, 1.0}, {0.6f, 0.9f, 0.0, 1.0, 1.0, 1.0}, {2.1f, 0.9f, 0.0, 1.0, 1.0, 1.0}};
        double[][] quad = new double[][]{{0.0, 0.0, 0.0, 1.0, 1.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 1.0}};
        double[][] tri = new double[][]{{0.3f, 0.3f, 0.0, 0.0, 0.0, 0.0}, {0.7f, 0.3f, 0.0, 0.0, 0.0, 0.0}, {0.5, 0.7f, 0.0, 0.0, 0.0, 0.0}};
        this.setWindingRule(100132);
        this.beginPolygon();
        this.beginContour();
        this.renderContour(star, 5);
        this.endContour();
        this.endPolygon();
        GL11.glTranslatef((float)-2.0f, (float)0.0f, (float)0.0f);
        this.setWindingRule(100130);
        this.beginPolygon();
        this.beginContour();
        this.renderContour(quad, 4);
        this.endContour();
        this.beginContour();
        this.renderContour(tri, 3);
        this.endContour();
        this.endPolygon();
        this.end();
    }

    private void start() throws LWJGLException {
        this.createDisplay();
        this.init();
        this.loop();
    }

    public static void main(String[] argv) throws LWJGLException {
        TessellationTest test = new TessellationTest();
        test.start();
    }
}

