/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Configuration;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnectionRequest;

class NetPackageRequest
extends NetConnectionRequest {
    private static final String COLLECTIONNAME = "NULLID";

    NetPackageRequest(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    private void buildCommonPKGNAMinfo(Section section) throws SqlException {
        String collectionToFlow = COLLECTIONNAME;
        int maxIdentifierLength = 255;
        CcsidManager ccsidMgr = this.netAgent_.getCurrentCcsidManager();
        byte[] dbnameBytes = ccsidMgr.convertFromJavaString(this.netAgent_.netConnection_.databaseName_, this.netAgent_);
        byte[] collectionToFlowBytes = ccsidMgr.convertFromJavaString(collectionToFlow, this.netAgent_);
        byte[] pkgNameBytes = ccsidMgr.convertFromJavaString(section.getPackageName(), this.netAgent_);
        boolean scldtalenRequired = this.checkPKGNAMlengths(this.netAgent_.netConnection_.databaseName_, dbnameBytes.length, this.netAgent_.netConnection_.databaseMetaData_.serverSupportLongRDBNAM() ? 1024 : 255, 18);
        if (!scldtalenRequired) {
            scldtalenRequired = this.checkPKGNAMlengths(collectionToFlow, collectionToFlowBytes.length, maxIdentifierLength, 18);
        }
        if (!scldtalenRequired) {
            scldtalenRequired = this.checkPKGNAMlengths(section.getPackageName(), pkgNameBytes.length, maxIdentifierLength, 18);
        }
        if (!scldtalenRequired) {
            byte padByte = ccsidMgr.space_;
            this.writeScalarPaddedBytes(dbnameBytes, 18, padByte);
            this.writeScalarPaddedBytes(collectionToFlowBytes, 18, padByte);
            this.writeScalarPaddedBytes(pkgNameBytes, 18, padByte);
        } else {
            this.buildSCLDTA(dbnameBytes, 18);
            this.buildSCLDTA(collectionToFlowBytes, 18);
            this.buildSCLDTA(pkgNameBytes, 18);
        }
    }

    private void buildSCLDTA(byte[] identifier, int minimumLength) throws SqlException {
        int length = Math.max(minimumLength, identifier.length);
        this.write2Bytes(length);
        byte padByte = this.netAgent_.getCurrentCcsidManager().space_;
        this.writeScalarPaddedBytes(identifier, length, padByte);
    }

    void buildPKGNAMCSN(Section section) throws SqlException {
        if (!this.canCommandUseDefaultPKGNAMCSN()) {
            this.markLengthBytes(8467);
            if (section.getPKGNAMCBytes() != null) {
                this.writeStoredPKGNAMCBytes(section);
            } else {
                this.markForCachingPKGNAMCSN();
                this.buildCommonPKGNAMinfo(section);
                this.writeScalarPaddedBytes(Configuration.getDncPackageConsistencyToken(), 8, (byte)0);
                this.storePKGNAMCBytes(section);
            }
            this.write2Bytes(section.getSectionNumber());
            this.updateLengthBytes();
        } else {
            this.writeScalar2Bytes(8460, section.getSectionNumber());
        }
    }

    private void storePKGNAMCBytes(Section section) {
        int startPos = this.popMarkForCachingPKGNAMCSN();
        byte[] b = new byte[this.buffer.position() - startPos];
        this.buffer.position(startPos);
        this.buffer.get(b);
        section.setPKGNAMCBytes(b);
    }

    private void writeStoredPKGNAMCBytes(Section section) {
        this.writeBytes(section.getPKGNAMCBytes());
    }

    private boolean canCommandUseDefaultPKGNAMCSN() {
        return false;
    }

    private boolean checkPKGNAMlengths(String identifier, int length, int maxIdentifierLength, int lengthRequiringScldta) throws SqlException {
        if (length > maxIdentifierLength) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("42622"), identifier, maxIdentifierLength);
        }
        return length > lengthRequiringScldta;
    }

    private void buildNOCMorNOCS(String string) throws SqlException {
        if (string == null) {
            this.write2Bytes(65535);
        } else if (this.netAgent_.typdef_.isCcsidMbcSet()) {
            byte[] sqlBytes = string.getBytes(this.netAgent_.typdef_.getCcsidMbcEncoding());
            this.write1Byte(0);
            this.write4Bytes(sqlBytes.length);
            this.writeBytes(sqlBytes, sqlBytes.length);
            this.write1Byte(255);
        } else {
            byte[] sqlBytes = string.getBytes(this.netAgent_.typdef_.getCcsidSbcEncoding());
            this.write1Byte(255);
            this.write1Byte(0);
            this.write4Bytes(sqlBytes.length);
            this.writeBytes(sqlBytes, sqlBytes.length);
        }
    }

    private void buildSQLSTTGRP(String string) throws SqlException {
        this.buildNOCMorNOCS(string);
    }

    private void buildSQLSTT(String string) throws SqlException {
        this.buildSQLSTTGRP(string);
    }

    protected void buildSQLSTTcommandData(String sql) throws SqlException {
        this.createEncryptedCommandData();
        int loc = this.buffer.position();
        this.markLengthBytes(9236);
        this.buildSQLSTT(sql);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(loc);
        }
    }

    protected void buildSQLATTRcommandData(String sql) throws SqlException {
        this.createEncryptedCommandData();
        int loc = this.buffer.position();
        this.markLengthBytes(9296);
        this.buildSQLSTT(sql);
        this.updateLengthBytes();
        if (this.netAgent_.netConnection_.getSecurityMechanism() == 12 || this.netAgent_.netConnection_.getSecurityMechanism() == 13) {
            this.encryptDataStream(loc);
        }
    }

    void encryptDataStream(int lengthLocation) throws SqlException {
        byte[] clearedBytes = new byte[this.buffer.position() - lengthLocation];
        this.buffer.position(lengthLocation);
        this.buffer.get(clearedBytes);
        byte[] encryptedBytes = this.netAgent_.netConnection_.getEncryptionManager().encryptData(clearedBytes, 9, this.netAgent_.netConnection_.getTargetPublicKey(), this.netAgent_.netConnection_.getTargetPublicKey());
        this.buffer.position(lengthLocation);
        this.writeBytes(encryptedBytes);
        this.buffer.putShort(lengthLocation - 6, (short)encryptedBytes.length);
    }
}

