/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.BasicNoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.w3c.dom.Element;

class TemporaryRowHolderResultSet
implements CursorResultSet,
NoPutResultSet,
Cloneable {
    private ExecRow[] rowArray;
    private int numRowsOut;
    private ScanController scan;
    private TransactionController tc;
    private boolean isOpen;
    private boolean finished;
    private ExecRow currentRow;
    private ResultDescription resultDescription;
    private boolean isAppendable = false;
    private long positionIndexConglomId;
    private boolean isVirtualMemHeap;
    private boolean currRowFromMem;
    private TemporaryRowHolderImpl holder;
    ConglomerateController heapCC;
    private RowLocation baseRowLocation;
    DataValueDescriptor[] indexRow;
    ScanController indexsc;

    public TemporaryRowHolderResultSet(TransactionController tc, ExecRow[] rowArray, ResultDescription resultDescription, boolean isVirtualMemHeap, TemporaryRowHolderImpl holder) {
        this(tc, rowArray, resultDescription, isVirtualMemHeap, false, 0L, holder);
    }

    public TemporaryRowHolderResultSet(TransactionController tc, ExecRow[] rowArray, ResultDescription resultDescription, boolean isVirtualMemHeap, boolean isAppendable, long positionIndexConglomId, TemporaryRowHolderImpl holder) {
        this.tc = tc;
        this.rowArray = rowArray;
        this.resultDescription = resultDescription;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        this.isVirtualMemHeap = isVirtualMemHeap;
        this.isAppendable = isAppendable;
        this.positionIndexConglomId = positionIndexConglomId;
        SanityManager.ASSERT((rowArray != null ? 1 : 0) != 0, (String)"rowArray is null");
        SanityManager.ASSERT((rowArray.length > 0 ? 1 : 0) != 0, (String)"rowArray has no elements, need at least one");
        this.holder = holder;
    }

    public void reset(ExecRow[] rowArray) {
        this.rowArray = rowArray;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        SanityManager.ASSERT((rowArray != null ? 1 : 0) != 0, (String)"rowArray is null");
        SanityManager.ASSERT((rowArray.length > 0 ? 1 : 0) != 0, (String)"rowArray has no elements, need at least one");
    }

    public void reStartScan(long currentConglomId, long pconglomId) throws StandardException {
        if (this.isAppendable) {
            SanityManager.ASSERT((currentConglomId == this.holder.getTemporaryConglomId() ? 1 : 0) != 0, (String)("currentConglomId(" + currentConglomId + ") == holder.getTemporaryConglomeateId (" + this.holder.getTemporaryConglomId() + ")"));
            this.positionIndexConglomId = pconglomId;
            this.setupPositionBasedScan(this.numRowsOut);
        } else {
            --this.numRowsOut;
        }
    }

    private static int[] supersetofAllColumns(int[] columnsArray1, int[] columnsArray2) {
        int i;
        int maxLength = columnsArray1.length + columnsArray2.length;
        int[] maxArray = new int[maxLength];
        for (i = 0; i < maxLength; ++i) {
            maxArray[i] = -1;
        }
        for (i = 0; i < columnsArray1.length; ++i) {
            maxArray[i] = columnsArray1[i];
        }
        int validColsPosition = columnsArray1.length;
        for (int i2 = 0; i2 < columnsArray2.length; ++i2) {
            boolean found = false;
            for (int j = 0; j < validColsPosition; ++j) {
                if (maxArray[j] != columnsArray2[i2]) continue;
                found = true;
                break;
            }
            if (found) continue;
            maxArray[validColsPosition] = columnsArray2[i2];
            ++validColsPosition;
        }
        maxArray = TemporaryRowHolderResultSet.shrinkArray(maxArray);
        Arrays.sort(maxArray);
        return maxArray;
    }

    private static int[] shrinkArray(int[] columnsArrary) {
        int countOfColsRefedInArray = 0;
        int numberOfColsInTriggerTable = columnsArrary.length;
        for (int i = 0; i < numberOfColsInTriggerTable; ++i) {
            if (columnsArrary[i] == -1) continue;
            ++countOfColsRefedInArray;
        }
        if (countOfColsRefedInArray > 0) {
            int[] tempArrayOfNeededColumns = new int[countOfColsRefedInArray];
            int j = 0;
            for (int i = 0; i < numberOfColsInTriggerTable; ++i) {
                if (columnsArrary[i] == -1) continue;
                tempArrayOfNeededColumns[j++] = columnsArrary[i];
            }
            return tempArrayOfNeededColumns;
        }
        return null;
    }

    private static int[] justTheRequiredColumnsPositions(int[] columnsArrary) {
        int countOfColsRefedInArray = 0;
        int numberOfColsInTriggerTable = columnsArrary.length;
        for (int i = 0; i < numberOfColsInTriggerTable; ++i) {
            if (columnsArrary[i] == -1) continue;
            ++countOfColsRefedInArray;
        }
        if (countOfColsRefedInArray > 0) {
            int[] tempArrayOfNeededColumns = new int[countOfColsRefedInArray];
            int j = 0;
            for (int i = 0; i < numberOfColsInTriggerTable; ++i) {
                if (columnsArrary[i] == -1) continue;
                tempArrayOfNeededColumns[j++] = i + 1;
            }
            return tempArrayOfNeededColumns;
        }
        return null;
    }

    public static TemporaryRowHolderResultSet getNewRSOnCurrentRow(TriggerDescriptor triggerd, Activation activation, CursorResultSet rs, int[] colsReadFromTable) throws StandardException {
        TemporaryRowHolderImpl singleRow;
        DataDictionary dd = activation.getLanguageConnectionContext().getDataDictionary();
        if (!dd.checkVersion(210, null)) {
            TemporaryRowHolderImpl singleRow2 = new TemporaryRowHolderImpl(activation, null, rs.getResultDescription());
            singleRow2.insert(rs.getCurrentRow());
            return (TemporaryRowHolderResultSet)singleRow2.getResultSet();
        }
        int[] referencedColsInTriggerAction = triggerd.getReferencedColsInTriggerAction();
        int[] referencedColsInTrigger = triggerd.getReferencedCols();
        if (referencedColsInTrigger != null && triggerd.isRowTrigger() && referencedColsInTriggerAction != null && referencedColsInTriggerAction.length != 0) {
            int i;
            int[] actualColsReadFromTable;
            int[] colsInTrigger = TemporaryRowHolderResultSet.supersetofAllColumns(referencedColsInTrigger, referencedColsInTriggerAction);
            int colsCountInTrigger = colsInTrigger.length;
            int[] colsReallyNeeded = new int[colsCountInTrigger];
            if (colsReadFromTable != null) {
                actualColsReadFromTable = TemporaryRowHolderResultSet.justTheRequiredColumnsPositions(colsReadFromTable);
            } else {
                int colsInTriggerTable = triggerd.getTableDescriptor().getNumberOfColumns();
                actualColsReadFromTable = new int[colsInTriggerTable];
                for (i = 1; i <= colsInTriggerTable; ++i) {
                    actualColsReadFromTable[i - 1] = i;
                }
            }
            int indexInActualColsReadFromTable = 0;
            block1: for (i = 0; i < colsCountInTrigger; ++i) {
                while (indexInActualColsReadFromTable < actualColsReadFromTable.length) {
                    if (actualColsReadFromTable[indexInActualColsReadFromTable] == colsInTrigger[i]) {
                        colsReallyNeeded[i] = indexInActualColsReadFromTable + 1;
                        continue block1;
                    }
                    ++indexInActualColsReadFromTable;
                }
            }
            singleRow = new TemporaryRowHolderImpl(activation, null, activation.getLanguageConnectionContext().getLanguageFactory().getResultDescription(rs.getResultDescription(), colsReallyNeeded));
            ExecRow row = activation.getExecutionFactory().getValueRow(colsCountInTrigger);
            for (int i2 = 0; i2 < colsCountInTrigger; ++i2) {
                row.setColumn(i2 + 1, rs.getCurrentRow().getColumn(colsReallyNeeded[i2]));
            }
            singleRow.insert(row);
        } else {
            singleRow = new TemporaryRowHolderImpl(activation, null, rs.getResultDescription());
            singleRow.insert(rs.getCurrentRow());
        }
        return (TemporaryRowHolderResultSet)singleRow.getResultSet();
    }

    @Override
    public void markAsTopResultSet() {
    }

    @Override
    public void openCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
            return;
        }
        if (this.scan != null) {
            this.scan.reopenScan(null, 0, null, null, 0);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (this.isAppendable) {
            return this.getNextAppendedRow();
        }
        if (this.isVirtualMemHeap && this.holder.lastArraySlot >= 0) {
            ++this.numRowsOut;
            this.currentRow = this.rowArray[this.holder.lastArraySlot];
            this.currRowFromMem = true;
            return this.currentRow;
        }
        if (this.numRowsOut++ <= this.holder.lastArraySlot) {
            this.currentRow = this.rowArray[this.numRowsOut - 1];
            return this.currentRow;
        }
        if (this.holder.getTemporaryConglomId() == 0L) {
            return null;
        }
        if (this.scan == null) {
            this.scan = this.tc.openScan(this.holder.getTemporaryConglomId(), false, 0, 7, 5, null, null, 0, null, null, 0);
        } else if (this.isVirtualMemHeap && this.holder.state == 1) {
            this.holder.state = 2;
            this.scan.reopenScan(null, 0, null, null, 0);
        }
        if (this.scan.next()) {
            this.currentRow = this.rowArray[0].getNewNullRow();
            this.scan.fetch(this.currentRow.getRowArray());
            this.currRowFromMem = false;
            return this.currentRow;
        }
        return null;
    }

    public void deleteCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isVirtualMemHeap, (String)"deleteCurrentRow is not implemented");
        if (this.currRowFromMem) {
            if (this.holder.lastArraySlot > 0) {
                this.rowArray[this.holder.lastArraySlot] = null;
            }
            --this.holder.lastArraySlot;
        } else {
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.scan.newRowLocationTemplate();
            }
            this.scan.fetchLocation(this.baseRowLocation);
            if (this.heapCC == null) {
                this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 4, 7, 5);
            }
            this.heapCC.delete(this.baseRowLocation);
        }
    }

    private void setupPositionBasedScan(long position) throws StandardException {
        if (this.holder.getTemporaryConglomId() == 0L) {
            return;
        }
        if (this.heapCC == null) {
            this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 0, 7, 5);
        }
        this.currentRow = this.rowArray[0].getNewNullRow();
        this.indexRow = new DataValueDescriptor[2];
        this.indexRow[0] = new SQLLongint(position);
        this.indexRow[1] = this.heapCC.newRowLocationTemplate();
        DataValueDescriptor[] searchRow = new DataValueDescriptor[]{new SQLLongint(position)};
        if (this.indexsc == null) {
            this.indexsc = this.tc.openScan(this.positionIndexConglomId, false, 0, 7, 5, null, searchRow, 1, null, null, -1);
        } else {
            this.indexsc.reopenScan(searchRow, 1, null, null, -1);
        }
    }

    private ExecRow getNextAppendedRow() throws StandardException {
        if (this.indexsc == null) {
            return null;
        }
        if (!this.indexsc.fetchNext(this.indexRow)) {
            return null;
        }
        RowLocation baseRowLocation = (RowLocation)this.indexRow[1];
        boolean base_row_exists = this.heapCC.fetch(baseRowLocation, this.currentRow.getRowArray(), null);
        SanityManager.ASSERT((boolean)base_row_exists, (String)"base row disappeared.");
        ++this.numRowsOut;
        return this.currentRow;
    }

    @Override
    public int getPointOfAttachment() {
        return -1;
    }

    @Override
    public int getScanIsolationLevel() {
        return 5;
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
    }

    @Override
    public double getEstimatedRowCount() {
        return 0.0;
    }

    @Override
    public int resultSetNumber() {
        return 0;
    }

    @Override
    public void setCurrentRow(ExecRow row) {
        this.currentRow = row;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"resultSet expected to be open");
        return this.currentRow;
    }

    @Override
    public RowLocation getRowLocation() {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"resultSet expected to be open");
        return null;
    }

    @Override
    public void close() throws StandardException {
        this.isOpen = false;
        this.numRowsOut = 0;
        this.currentRow = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public long modifiedRowCount() {
        return 0L;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    @Override
    public void open() throws StandardException {
        this.openCore();
    }

    @Override
    public ExecRow getAbsoluteRow(int row) throws StandardException {
        SanityManager.THROWASSERT((String)"getAbsoluteRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int row) throws StandardException {
        SanityManager.THROWASSERT((String)"getRelativeRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        SanityManager.THROWASSERT((String)"setBeforeFirstRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getFirstRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getPreviousRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getLastRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getLastRow() not expected to be called yet.");
        return null;
    }

    @Override
    public boolean checkRowPosition(int isType) {
        return false;
    }

    @Override
    public int getRowNumber() {
        return 0;
    }

    @Override
    public void cleanUp() throws StandardException {
        this.close();
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
        this.finished = true;
        this.close();
    }

    @Override
    public long getExecuteTime() {
        return 0L;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        return null;
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        return null;
    }

    @Override
    public long getTimeSpent(int type) {
        return 0L;
    }

    @Override
    public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public boolean requiresRelocking() {
        SanityManager.THROWASSERT((String)("requiresRelocking() not expected to be called for " + this.getClass().getName()));
        return false;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        return null;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public void setHasDeferrableChecks() {
        SanityManager.NOTREACHED();
    }

    @Override
    public boolean needsRowLocationForDeferredCheckConstraints() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
    }

    @Override
    public void offendingRowLocation(RowLocation rl, long containdId) throws StandardException {
        SanityManager.NOTREACHED();
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    public Object clone() {
        Object clo = null;
        try {
            clo = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clo;
    }

    @Override
    public void addWarning(SQLWarning w) {
        this.getActivation().addWarning(w);
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void updateRow(ExecRow row, RowChanger rowChanger) throws StandardException {
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public final Activation getActivation() {
        return this.holder.activation;
    }

    @Override
    public Element toXML(Element parentNode, String tag) throws Exception {
        return BasicNoPutResultSetImpl.childrenToXML(BasicNoPutResultSetImpl.toXML(parentNode, tag, this), this);
    }
}

