/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;

class HasNodeVisitor
implements Visitor {
    protected boolean hasNode;
    private Class<?> nodeClass;
    private Class<?> skipOverClass;

    HasNodeVisitor(Class<?> nodeClass) {
        this.nodeClass = nodeClass;
    }

    HasNodeVisitor(Class<?> nodeClass, Class<?> skipOverClass) {
        this.nodeClass = nodeClass;
        this.skipOverClass = skipOverClass;
    }

    @Override
    public Visitable visit(Visitable node) {
        if (this.nodeClass.isInstance(node)) {
            this.hasNode = true;
        }
        return node;
    }

    @Override
    public boolean stopTraversal() {
        return this.hasNode;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(node);
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }

    boolean hasNode() {
        return this.hasNode;
    }

    void reset() {
        this.hasNode = false;
    }
}

