/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class CallStatementNode
extends DMLStatementNode {
    private JavaToSQLValueNode methodCall;

    CallStatementNode(JavaToSQLValueNode methodCall, ContextManager cm) {
        super(null, cm);
        this.methodCall = methodCall;
        this.methodCall.getJavaValueNode().markForCallStatement();
    }

    @Override
    String statementToString() {
        return "CALL";
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.methodCall != null) {
            this.printLabel(depth, "methodCall: ");
            this.methodCall.treePrint(depth + 1);
        }
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        SanityManager.ASSERT((dd != null ? 1 : 0) != 0, (String)"Failed to get data dictionary");
        SubqueryList subqueries = new SubqueryList(this.getContextManager());
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.methodCall = (JavaToSQLValueNode)this.methodCall.bindExpression(new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), subqueries, null);
        if (subqueries.size() != 0) {
            throw StandardException.newException((String)"42X74", (Object[])new Object[0]);
        }
        this.checkReliability();
        this.getCompilerContext().popCurrentPrivType();
    }

    @Override
    public void optimizeStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        SanityManager.ASSERT((dd != null ? 1 : 0) != 0, (String)"Failed to get data dictionary");
        this.methodCall = (JavaToSQLValueNode)this.methodCall.preprocess(this.getCompilerContext().getNumTables(), new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()), null, null);
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateParameterValueSet(acb);
        JavaValueNode methodCallBody = this.methodCall.getJavaValueNode();
        methodCallBody.markReturnValueDiscarded();
        MethodBuilder userExprFun = acb.newGeneratedFun("void", 1);
        userExprFun.addThrownException("java.lang.Exception");
        methodCallBody.generate(acb, userExprFun);
        userExprFun.endStatement();
        userExprFun.methodReturn();
        userExprFun.complete();
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushMethodReference(mb, userExprFun);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getCallStatementResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
    }

    @Override
    public ResultDescription makeResultDescription() {
        return null;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.methodCall != null) {
            this.methodCall = (JavaToSQLValueNode)this.methodCall.accept(v);
        }
    }

    @Override
    int getPrivType() {
        return 6;
    }

    private void checkReliability() throws StandardException {
        if (this.getSQLAllowedInProcedure() == 0 && this.getCompilerContext().getReliability() == 2048) {
            throw StandardException.newException((String)"42Z9D.S.1", (Object[])new Object[0]);
        }
    }

    private short getSQLAllowedInProcedure() {
        RoutineAliasInfo routineInfo = ((MethodCallNode)this.methodCall.getJavaValueNode()).routineInfo;
        SanityManager.ASSERT((routineInfo != null ? 1 : 0) != 0, (String)"Failed to get routineInfo");
        return routineInfo.getSQLAllowed();
    }
}

