/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;

class ColumnOrdering {
    int myDirection;
    private final ArrayList<Integer> columns = new ArrayList();
    private final ArrayList<Integer> tables = new ArrayList();

    ColumnOrdering(int direction) {
        this.myDirection = direction;
    }

    boolean ordered(int direction, int tableNumber, int columnNumber) {
        if (direction != 3 && direction != this.myDirection) {
            return false;
        }
        return this.contains(tableNumber, columnNumber);
    }

    boolean contains(int tableNumber, int columnNumber) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Integer col = this.columns.get(i);
            Integer tab = this.tables.get(i);
            if (tab != tableNumber || col != columnNumber) continue;
            return true;
        }
        return false;
    }

    int direction() {
        return this.myDirection;
    }

    void addColumn(int tableNumber, int columnNumber) {
        this.tables.add(tableNumber);
        this.columns.add(columnNumber);
    }

    void removeColumns(int tableNumber) {
        for (int i = this.tables.size() - 1; i >= 0; --i) {
            Integer tab = this.tables.get(i);
            if (tab != tableNumber) continue;
            this.tables.remove(i);
            this.columns.remove(i);
        }
    }

    boolean empty() {
        return this.tables.isEmpty();
    }

    ColumnOrdering cloneMe() {
        ColumnOrdering retval = new ColumnOrdering(this.myDirection);
        for (int i = 0; i < this.columns.size(); ++i) {
            retval.columns.add(this.columns.get(i));
            retval.tables.add(this.tables.get(i));
        }
        return retval;
    }

    boolean hasTable(int tableNumber) {
        return this.tables.contains(tableNumber);
    }

    boolean hasAnyOtherTable(int tableNumber) {
        for (int i = 0; i < this.tables.size(); ++i) {
            Integer tab = this.tables.get(i);
            if (tab == tableNumber) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Object retval = "";
        retval = (String)retval + "Direction: " + this.myDirection;
        for (int i = 0; i < this.columns.size(); ++i) {
            retval = (String)retval + " Table " + String.valueOf(this.tables.get(i)) + ", Column " + String.valueOf(this.columns.get(i));
        }
        return retval;
    }
}

