/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.sdjwt.DisclosureSpec;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;
import org.keycloak.sdjwt.SdJwt;

public class SdJwtFacade {
    private final SignatureSignerContext signer;
    private final String hashAlgorithm;
    private final String jwsType;

    public SdJwtFacade(SignatureSignerContext signer, String hashAlgorithm, String jwsType) {
        this.signer = signer;
        this.hashAlgorithm = hashAlgorithm;
        this.jwsType = jwsType;
    }

    public SdJwt createSdJwt(JsonNode claimSet, DisclosureSpec disclosureSpec) {
        return SdJwt.builder().withClaimSet(claimSet).withDisclosureSpec(disclosureSpec).withSigner(this.signer).withHashAlgorithm(this.hashAlgorithm).withJwsType(this.jwsType).build();
    }

    public void verifySdJwt(SdJwt sdJwt, List<SignatureVerifierContext> issuerVerifyingKeys, IssuerSignedJwtVerificationOpts verificationOpts) throws VerificationException {
        try {
            sdJwt.verify(issuerVerifyingKeys, verificationOpts);
        }
        catch (VerificationException e) {
            throw new VerificationException("SD-JWT verification failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getSdJwtString(SdJwt sdJwt) {
        return sdJwt.toString();
    }
}

