/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.representations.idm.IdentityProviderRepresentation;
import org.keycloak.representations.idm.MemberRepresentation;
import org.keycloak.representations.idm.OrganizationDomainRepresentation;

public class OrganizationRepresentation {
    private String id;
    private String name;
    private String alias;
    private boolean enabled = true;
    private String description;
    private String redirectUrl;
    private Map<String, List<String>> attributes;
    private Set<OrganizationDomainRepresentation> domains;
    private List<MemberRepresentation> members;
    private List<IdentityProviderRepresentation> identityProviders;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public OrganizationRepresentation singleAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, List<String>>();
        }
        this.attributes.put(name, Arrays.asList(value));
        return this;
    }

    public Set<OrganizationDomainRepresentation> getDomains() {
        return this.domains;
    }

    public OrganizationDomainRepresentation getDomain(String name) {
        if (this.domains == null) {
            return null;
        }
        return this.domains.stream().filter(organizationDomainRepresentation -> name.equals(organizationDomainRepresentation.getName())).findAny().orElse(null);
    }

    public void addDomain(OrganizationDomainRepresentation domain) {
        if (this.domains == null) {
            this.domains = new HashSet<OrganizationDomainRepresentation>();
        }
        this.domains.add(domain);
    }

    public void removeDomain(OrganizationDomainRepresentation domain) {
        if (this.domains == null) {
            return;
        }
        this.getDomains().remove(domain);
    }

    public List<MemberRepresentation> getMembers() {
        return this.members;
    }

    public void setMembers(List<MemberRepresentation> members) {
        this.members = members;
    }

    public void addMember(MemberRepresentation member) {
        if (this.members == null) {
            this.members = new ArrayList<MemberRepresentation>();
        }
        this.members.add(member);
    }

    public List<IdentityProviderRepresentation> getIdentityProviders() {
        return this.identityProviders;
    }

    public void setIdentityProviders(List<IdentityProviderRepresentation> identityProviders) {
        this.identityProviders = identityProviders;
    }

    public void addIdentityProvider(IdentityProviderRepresentation idp) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList<IdentityProviderRepresentation>();
        }
        this.identityProviders.add(idp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof OrganizationRepresentation)) {
            return false;
        }
        OrganizationRepresentation that = (OrganizationRepresentation)o;
        return this.id != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        if (this.id == null) {
            return super.hashCode();
        }
        return this.id.hashCode();
    }
}

