/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"Math"})
public class RubyMath {
    public static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    public static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};
    private static int DBL_MANT_DIG = 53;
    private static int DBL_MAX_EXP = 1024;
    private static double LOG_E_2 = Math.log(2.0);
    private static double LOG_10_2 = Math.log10(2.0);
    public static final double[] ERFC_COEF = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19};
    public static final double[] ERFC2_COEF = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18, -7.663762920320386E-19, 1.9008192513627452E-19};
    public static final double[] ERFCC_COEF = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};
    private static final double[] FACTORIAL = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21};
    private static final double[] NEMES_GAMMA_COEFF = new double[]{1.0, 0.0, 0.08333333333333333, 0.0, 6.944444444444445E-4, 0.0, 6.586199294532628E-4, 0.0, -5.328781782774838E-4, 0.0, 7.927858870060838E-4, 0.0, -0.0018475818932203302, 0.0, 0.006250678247849418, 0.0, -0.02901710246301151, 0.0, 0.1771845724249131, 0.0, -1.3774768170399354};

    public static RubyModule createMathModule(ThreadContext context) {
        return ((RubyModule)((RubyModule)Define.defineModule(context, "Math").defineConstant(context, "E", Convert.asFloat(context, Math.E))).defineConstant(context, "PI", Convert.asFloat(context, Math.PI))).defineMethods(context, RubyMath.class);
    }

    private static void domainCheck(ThreadContext context, double value2, String msg) {
        if (Double.isNaN(value2)) {
            throw context.runtime.newMathDomainError(msg);
        }
    }

    public static double chebylevSerie(double x, double[] coef) {
        double b1 = 0.0;
        double b0 = 0.0;
        double b2 = 0.0;
        double twox = 2.0 * x;
        for (int i2 = coef.length - 1; i2 >= 0; --i2) {
            b2 = b1;
            b1 = b0;
            b0 = twox * b1 - b2 + coef[i2];
        }
        return 0.5 * (b0 - b2);
    }

    public static double sign(double x, double y) {
        double abs3 = x < 0.0 ? -x : x;
        return y < 0.0 ? -abs3 : abs3;
    }

    @JRubyMethod(name={"atan2"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atan2(ThreadContext context, IRubyObject recv2, IRubyObject x, IRubyObject y) {
        return Convert.asFloat(context, Math.atan2(Convert.toDouble(context, x), Convert.toDouble(context, y)));
    }

    @JRubyMethod(name={"cos"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat cos(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        return Convert.asFloat(context, Math.cos(Convert.toDouble(context, x)));
    }

    @JRubyMethod(name={"sin"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sin(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        return Convert.asFloat(context, Math.sin(Convert.toDouble(context, x)));
    }

    @JRubyMethod(name={"tan"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat tan(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        return Convert.asFloat(context, Math.tan(Convert.toDouble(context, x)));
    }

    @JRubyMethod(name={"asin"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat asin(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = Convert.toDouble(context, x);
        if (value2 < -1.0 || value2 > 1.0) {
            throw context.runtime.newMathDomainError("asin");
        }
        return Convert.asFloat(context, Math.asin(value2));
    }

    @JRubyMethod(name={"acos"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat acos(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = Convert.toDouble(context, x);
        if (value2 < -1.0 || value2 > 1.0) {
            throw context.runtime.newMathDomainError("acos");
        }
        return Convert.asFloat(context, Math.acos(value2));
    }

    @JRubyMethod(name={"atan"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atan(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        return Convert.asFloat(context, Math.atan(Convert.toDouble(context, x)));
    }

    @JRubyMethod(name={"cosh"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat cosh(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = Convert.toDouble(context, x);
        return Convert.asFloat(context, (Math.exp(value2) + Math.exp(-value2)) / 2.0);
    }

    @JRubyMethod(name={"sinh"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sinh(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = Convert.toDouble(context, x);
        return Convert.asFloat(context, (Math.exp(value2) - Math.exp(-value2)) / 2.0);
    }

    @JRubyMethod(name={"tanh"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat tanh(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        return Convert.asFloat(context, Math.tanh(Convert.toDouble(context, x)));
    }

    @JRubyMethod(name={"acosh"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat acosh(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double result2;
        double value2 = Convert.toDouble(context, x);
        if (Double.isNaN(value2)) {
            result2 = Double.NaN;
        } else {
            if (value2 < 1.0) {
                throw context.runtime.newMathDomainError("acosh");
            }
            result2 = value2 < 9.490626562E7 ? Math.log(value2 + Math.sqrt(value2 * value2 - 1.0)) : 0.6931471805599453 + Math.log(value2);
        }
        return Convert.asFloat(context, result2);
    }

    @JRubyMethod(name={"asinh"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat asinh(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double result2;
        double value2 = Convert.toDouble(context, x);
        double y = Math.abs(value2);
        if (Double.isNaN(value2)) {
            result2 = Double.NaN;
        } else if (y <= 1.05367E-8) {
            result2 = value2;
        } else if (y <= 1.0) {
            result2 = value2 * (1.0 + RubyMath.chebylevSerie(2.0 * value2 * value2 - 1.0, ASINH_COEF));
        } else if (y < 9.490626562E7) {
            result2 = Math.log(value2 + Math.sqrt(value2 * value2 + 1.0));
        } else {
            result2 = 0.6931471805599453 + Math.log(y);
            if (value2 < 0.0) {
                result2 *= -1.0;
            }
        }
        return Convert.asFloat(context, result2);
    }

    @JRubyMethod(name={"atanh"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat atanh(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = Convert.toDouble(context, x);
        if (value2 < -1.0 || value2 > 1.0) {
            throw context.runtime.newMathDomainError("atanh");
        }
        double y = Math.abs(value2);
        double result2 = Double.isNaN(value2) ? Double.NaN : (y < 1.82501E-8 ? value2 : (y <= 0.5 ? value2 * (1.0 + RubyMath.chebylevSerie(8.0 * value2 * value2 - 1.0, ATANH_COEF)) : (y < 1.0 ? 0.5 * Math.log((1.0 + value2) / (1.0 - value2)) : (y == 1.0 ? value2 * Double.POSITIVE_INFINITY : Double.NaN))));
        return Convert.asFloat(context, result2);
    }

    @JRubyMethod(name={"exp"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat exp(ThreadContext context, IRubyObject recv2, IRubyObject exponent2) {
        return RubyMath.exp(context, exponent2);
    }

    public static RubyFloat exp(ThreadContext context, IRubyObject exponent2) {
        return Convert.asFloat(context, Math.exp(Convert.toDouble(context, exponent2)));
    }

    private static double[] get_double_rshift(ThreadContext context, IRubyObject x) {
        int numbits = 0;
        if (x instanceof RubyBignum) {
            RubyBignum bignum = (RubyBignum)x;
            numbits = bignum.getValue().abs().bitLength();
            if (bignum.getValue().signum() > 0 && numbits >= DBL_MAX_EXP) {
                x = bignum.op_rshift(context, numbits -= DBL_MANT_DIG);
            } else {
                numbits = 0;
            }
        }
        return new double[]{Convert.toDouble(context, x), numbits};
    }

    @JRubyMethod(name={"log"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log(ThreadContext context, IRubyObject recv2, IRubyObject val) {
        return RubyMath.log(context, val);
    }

    public static RubyFloat log(ThreadContext context, IRubyObject val) {
        double[] ret = RubyMath.get_double_rshift(context, val);
        if (ret[0] < 0.0) {
            throw context.runtime.newMathDomainError("log");
        }
        return Convert.asFloat(context, Math.log(ret[0]) + ret[1] * LOG_E_2);
    }

    @JRubyMethod(name={"log"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log(ThreadContext context, IRubyObject recv2, IRubyObject val, IRubyObject base) {
        double[] ret = RubyMath.get_double_rshift(context, val);
        double _base = Convert.toDouble(context, base);
        if (ret[0] < 0.0 || _base < 0.0) {
            throw context.runtime.newMathDomainError("log");
        }
        return Convert.asFloat(context, Math.log(ret[0]) / Math.log(_base) + ret[1]);
    }

    public static RubyFloat log(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        return args2.length == 2 ? RubyMath.log(context, recv2, args2[0], args2[1]) : RubyMath.log(context, recv2, args2[0]);
    }

    @JRubyMethod(name={"log10"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log10(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double[] ret = RubyMath.get_double_rshift(context, x);
        if (ret[0] < 0.0) {
            throw context.runtime.newMathDomainError("log10");
        }
        return Convert.asFloat(context, Math.log10(ret[0]) + ret[1] * LOG_10_2);
    }

    @JRubyMethod(name={"log2"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat log2(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double[] ret = RubyMath.get_double_rshift(context, x);
        if (ret[0] < 0.0) {
            throw context.runtime.newMathDomainError("log2");
        }
        return Convert.asFloat(context, Math.log(ret[0]) / LOG_E_2 + ret[1]);
    }

    @JRubyMethod(name={"sqrt"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat sqrt(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = Convert.toDouble(context, x);
        if (value2 < 0.0) {
            throw context.runtime.newMathDomainError("sqrt");
        }
        return Convert.asFloat(context, value2 == 0.0 ? 0.0 : Math.sqrt(value2));
    }

    @JRubyMethod(name={"cbrt"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat cbrt(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        return Convert.asFloat(context, Math.cbrt(Convert.toDouble(context, x)));
    }

    @Deprecated(since="10.0.0.0")
    public static RubyFloat hypot19(ThreadContext context, IRubyObject recv2, IRubyObject x, IRubyObject y) {
        return RubyMath.hypot(context, recv2, x, y);
    }

    @JRubyMethod(name={"hypot"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat hypot(ThreadContext context, IRubyObject recv2, IRubyObject x, IRubyObject y) {
        double result2;
        double valuea = Convert.toDouble(context, x);
        double valueb = Convert.toDouble(context, y);
        if (Math.abs(valuea) > Math.abs(valueb)) {
            result2 = valueb / valuea;
            result2 = Math.abs(valuea) * Math.sqrt(1.0 + result2 * result2);
        } else if (valueb != 0.0) {
            result2 = valuea / valueb;
            result2 = Math.abs(valueb) * Math.sqrt(1.0 + result2 * result2);
        } else {
            result2 = Double.isNaN(valuea) || Double.isNaN(valueb) ? Double.NaN : 0.0;
        }
        return Convert.asFloat(context, result2);
    }

    @JRubyMethod(name={"frexp"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray frexp(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        double mantissa = Convert.toDouble(context, other);
        int sign2 = 1;
        long exponent2 = 0L;
        if (!Double.isInfinite(mantissa) && mantissa != 0.0) {
            if (mantissa < 0.0) {
                mantissa = -mantissa;
                sign2 = -1;
            }
            while (mantissa < 0.5) {
                mantissa *= 2.0;
                --exponent2;
            }
            while (mantissa >= 1.0) {
                mantissa *= 0.5;
                ++exponent2;
            }
        }
        return Create.newArray(context, (IRubyObject)Convert.asFloat(context, (double)sign2 * mantissa), (IRubyObject)Convert.asFixnum(context, exponent2));
    }

    @JRubyMethod(name={"ldexp"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat ldexp(ThreadContext context, IRubyObject recv2, IRubyObject mantissa, IRubyObject exponent2) {
        double m = Convert.toDouble(context, mantissa);
        int e = Convert.toInt(context, exponent2);
        return e > 1023 ? Convert.asFloat(context, m * Math.pow(2.0, e - 1023) * Math.pow(2.0, 1023.0)) : Convert.asFloat(context, m * Math.pow(2.0, e));
    }

    @JRubyMethod(name={"erf"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat erf(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = Convert.toDouble(context, x);
        double y = Math.abs(value2);
        double result2 = y <= 1.49012E-8 ? 2.0 * value2 / 1.772453850905516 : (y <= 1.0 ? value2 * (1.0 + RubyMath.chebylevSerie(2.0 * value2 * value2 - 1.0, ERFC_COEF)) : (y < 6.013687357 ? RubyMath.sign(1.0 - RubyMath.erfc((ThreadContext)context, (IRubyObject)recv2, (IRubyObject)Convert.asFloat((ThreadContext)context, (double)y)).value, value2) : (Double.isNaN(y) ? Double.NaN : RubyMath.sign(1.0, value2))));
        return Convert.asFloat(context, result2);
    }

    @JRubyMethod(name={"erfc"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat erfc(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double result2;
        double value2 = Convert.toDouble(context, x);
        double y = Math.abs(value2);
        if (value2 <= -6.013687357) {
            result2 = 2.0;
        } else if (y < 1.49012E-8) {
            result2 = 1.0 - 2.0 * value2 / 1.772453850905516;
        } else {
            double ysq = y * y;
            if (y < 1.0) {
                result2 = 1.0 - value2 * (1.0 + RubyMath.chebylevSerie(2.0 * ysq - 1.0, ERFC_COEF));
            } else if (y <= 4.0) {
                result2 = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie((8.0 / ysq - 5.0) / 3.0, ERFC2_COEF));
                if (value2 < 0.0) {
                    result2 = 2.0 - result2;
                }
                if (value2 < 0.0) {
                    result2 = 2.0 - result2;
                }
                if (value2 < 0.0) {
                    result2 = 2.0 - result2;
                }
            } else {
                result2 = Math.exp(-ysq) / y * (0.5 + RubyMath.chebylevSerie(8.0 / ysq - 1.0, ERFCC_COEF));
                if (value2 < 0.0) {
                    result2 = 2.0 - result2;
                }
            }
        }
        return Convert.asFloat(context, result2);
    }

    @JRubyMethod(name={"gamma"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyFloat gamma(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float((ThreadContext)context, (IRubyObject)x).value;
        double result2 = RubyMath.nemes_gamma(value2);
        if (Double.isInfinite(result2)) {
            result2 = value2 < 0.0 ? Double.NaN : (value2 == 0.0 && 1.0 / value2 < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (Double.isNaN(value2)) {
            return Convert.asFloat(context, Double.NaN);
        }
        RubyMath.domainCheck(context, result2, "gamma");
        return Convert.asFloat(context, result2);
    }

    @JRubyMethod(name={"lgamma"}, module=true, visibility=Visibility.PRIVATE)
    public static RubyArray lgamma(ThreadContext context, IRubyObject recv2, IRubyObject x) {
        double value2 = RubyKernel.new_float((ThreadContext)context, (IRubyObject)x).value;
        if (value2 < 0.0 && Double.isInfinite(value2)) {
            throw context.runtime.newMathDomainError("lgamma");
        }
        NemesLogGamma l = new NemesLogGamma(value2);
        return Create.newArray(context, (IRubyObject)Convert.asFloat(context, l.value), (IRubyObject)Convert.asFixnum(context, (int)l.sign));
    }

    public static double nemes_gamma(double x) {
        double int_part = (int)x;
        if (x - int_part == 0.0 && 0.0 < int_part && int_part <= (double)FACTORIAL.length) {
            return FACTORIAL[(int)int_part - 1];
        }
        NemesLogGamma l = new NemesLogGamma(x);
        return l.sign * Math.exp(l.value);
    }

    public static class NemesLogGamma {
        public final double value;
        public final double sign;

        public NemesLogGamma(double x) {
            if (Double.isInfinite(x)) {
                this.value = Double.POSITIVE_INFINITY;
                this.sign = 1.0;
                return;
            }
            if (Double.isNaN(x)) {
                this.value = Double.NaN;
                this.sign = 1.0;
                return;
            }
            double int_part = (int)x;
            this.sign = NemesLogGamma.signum(x, int_part);
            if (x - int_part == 0.0 && 0.0 < int_part && int_part <= (double)FACTORIAL.length) {
                this.value = Math.log(FACTORIAL[(int)int_part - 1]);
            } else if (x < 10.0) {
                double rising_factorial = 1.0;
                int i2 = 0;
                while ((double)i2 < (double)((int)Math.abs(x)) - int_part + 10.0) {
                    rising_factorial *= x + (double)i2;
                    ++i2;
                }
                NemesLogGamma l = new NemesLogGamma(x + (double)((int)Math.abs(x)) - int_part + 10.0);
                this.value = l.value - Math.log(Math.abs(rising_factorial));
            } else {
                double temp = 0.0;
                for (int i3 = 0; i3 < NEMES_GAMMA_COEFF.length; ++i3) {
                    temp += NEMES_GAMMA_COEFF[i3] * 1.0 / Math.pow(x, i3);
                }
                this.value = x * (Math.log(x) - 1.0 + Math.log(temp)) + (Math.log(2.0) + Math.log(Math.PI) - Math.log(x)) / 2.0;
            }
        }

        private static int signum(double x, double int_part) {
            return int_part % 2.0 == 0.0 && x - int_part != 0.0 && x < 0.0 || NemesLogGamma.negZero(x) ? -1 : 1;
        }

        private static boolean negZero(double x) {
            return x == 0.0 && Double.doubleToRawLongBits(x) != 0L;
        }
    }
}

