/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLRelationship;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SetNullOnNonNullableColumnCritic
extends CriticAndSettings {
    public SetNullOnNonNullableColumnCritic() {
        super(CriticAndSettings.StarterPlatformTypes.GENERIC.getName(), Messages.getString("SetNullOnNonNullableColumnCritic.name"));
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        SQLRelationship.UpdateDeleteRule updateRule;
        if (!(subject instanceof SQLRelationship.ColumnMapping)) {
            return Collections.emptyList();
        }
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        SQLRelationship.ColumnMapping cm = (SQLRelationship.ColumnMapping)subject;
        SQLRelationship.UpdateDeleteRule deleteRule = cm.getParent().getDeleteRule();
        final SQLColumn fkcol = cm.getFkColumn();
        if (deleteRule == SQLRelationship.UpdateDeleteRule.SET_NULL && !fkcol.isDefinitelyNullable()) {
            criticisms.add(new Criticism(subject, Messages.getString("SetNullOnNonNullableColumnCritic.deleteRuleCriticism", cm.getParent().getName(), fkcol.getName()), this, new CriticFix(Messages.getString("SetNullOnNonNullableColumnCritic.quickFix", fkcol.getName()), CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    fkcol.setNullable(1);
                }
            }));
        }
        if ((updateRule = cm.getParent().getUpdateRule()) == SQLRelationship.UpdateDeleteRule.SET_NULL && !fkcol.isDefinitelyNullable()) {
            criticisms.add(new Criticism(subject, Messages.getString("SetNullOnNonNullableColumnCritic.updateRuleCriticism", cm.getParent().getName(), fkcol.getName()), this, new CriticFix(Messages.getString("SetNullOnNonNullableColumnCritic.quickFix", fkcol.getName()), CriticFix.FixType.QUICK_FIX){

                @Override
                public void apply() {
                    fkcol.setNullable(1);
                }
            }));
        }
        return criticisms;
    }
}

