/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.graalvm.visualvm.heapviewer.utils.Bundle;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.HeapProgress;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.RequestProcessor;

public final class HeapOperations {
    private static Map<Heap, HeapOperations> INSTANCES;
    private volatile boolean referencesInitialized;
    private volatile RequestProcessor.Task referencesComputer;
    private volatile boolean gcrootsInitialized;
    private volatile RequestProcessor.Task gcrootsComputer;
    private volatile boolean retainedInitialized;
    private volatile RequestProcessor.Task retainedComputer;

    private HeapOperations() {
    }

    private static synchronized HeapOperations get(Heap heap) {
        if (INSTANCES == null) {
            INSTANCES = new WeakHashMap<Heap, HeapOperations>();
        }
        HeapOperations instance = INSTANCES.computeIfAbsent(heap, k -> new HeapOperations());
        return instance;
    }

    public static void initializeReferences(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeReferencesImpl(heap);
    }

    public static void initializeGCRoots(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeGCRootsImpl(heap);
    }

    public static void initializeRetainedSizes(Heap heap) throws InterruptedException {
        HeapOperations.get(heap).initializeRetainedSizesImpl(heap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeReferencesImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _referencesComputer;
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (this.referencesInitialized) {
                return;
            }
            if (this.referencesComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        OpProgressHandle pHandle = null;
                        try {
                            pHandle = new OpProgressHandle(Bundle.HeapOperations_ComputingReferences());
                            pHandle.setInitialDelay(1000);
                            pHandle.start(1000);
                            pHandle.setProgress(0);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getReferences();
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        HeapOperations heapOperations = HeapOperations.this;
                        synchronized (heapOperations) {
                            HeapOperations.this.referencesInitialized = true;
                            HeapOperations.this.referencesComputer = null;
                        }
                    }
                };
                _referencesComputer = this.referencesComputer = new RequestProcessor("References Computer").post(workerR);
            } else {
                _referencesComputer = this.referencesComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _referencesComputer.waitFinished(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeGCRootsImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _gcrootsComputer;
        this.initializeReferencesImpl(heap);
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (this.gcrootsInitialized) {
                return;
            }
            if (this.gcrootsComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        OpProgressHandle pHandle = null;
                        try {
                            pHandle = new OpProgressHandle(Bundle.HeapOperations_ComputingGCRoots());
                            pHandle.setInitialDelay(1000);
                            pHandle.start(1000);
                            pHandle.setProgress(0);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getNearestGCRootPointer();
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        HeapOperations heapOperations = HeapOperations.this;
                        synchronized (heapOperations) {
                            HeapOperations.this.gcrootsInitialized = true;
                            HeapOperations.this.gcrootsComputer = null;
                        }
                    }
                };
                _gcrootsComputer = this.gcrootsComputer = new RequestProcessor("GC Roots Computer").post(workerR);
            } else {
                _gcrootsComputer = this.gcrootsComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _gcrootsComputer.waitFinished(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRetainedSizesImpl(final Heap heap) throws InterruptedException {
        RequestProcessor.Task _retainedComputer;
        this.initializeGCRootsImpl(heap);
        HeapOperations heapOperations = this;
        synchronized (heapOperations) {
            if (this.retainedInitialized) {
                return;
            }
            if (this.retainedComputer == null) {
                Runnable workerR = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        OpProgressHandle pHandle = null;
                        try {
                            pHandle = new OpProgressHandle(Bundle.HeapOperations_ComputingRetainedSizes());
                            pHandle.setInitialDelay(1000);
                            pHandle.start();
                            pHandle.setRetainedSizesProgress(1000, 3000);
                            Instance dummy = (Instance)heap.getAllInstancesIterator().next();
                            dummy.getRetainedSize();
                            pHandle.setProgress(2000);
                            List classes = heap.getAllClasses();
                            if (!classes.isEmpty()) {
                                ((JavaClass)classes.get(0)).getRetainedSizeByClass();
                            }
                        }
                        finally {
                            if (pHandle != null) {
                                pHandle.finish();
                            }
                        }
                        HeapOperations heapOperations = HeapOperations.this;
                        synchronized (heapOperations) {
                            HeapOperations.this.retainedInitialized = true;
                            HeapOperations.this.retainedComputer = null;
                        }
                    }
                };
                _retainedComputer = this.retainedComputer = new RequestProcessor("Retained Sizes Computer").post(workerR);
            } else {
                _retainedComputer = this.retainedComputer;
            }
        }
        assert (!SwingUtilities.isEventDispatchThread());
        _retainedComputer.waitFinished(0L);
    }

    public static class OpProgressHandle {
        private final ProgressHandle handle;
        private Timer timer;

        public OpProgressHandle(String displayName) {
            this.handle = ProgressHandle.createHandle((String)displayName);
        }

        public void setInitialDelay(int millis) {
            this.handle.setInitialDelay(millis);
        }

        public void start() {
            this.handle.start();
        }

        public void start(int workunits) {
            this.handle.start(workunits);
        }

        public void setProgress(final int offset) {
            final long progressId = HeapProgress.getProgressId();
            if (this.timer != null) {
                this.timer.stop();
            }
            this.timer = new Timer(1500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int value = HeapProgress.getProgressValue((long)progressId);
                    if (value >= 0) {
                        handle.progress(value + offset);
                    } else {
                        timer.stop();
                    }
                }
            });
            this.timer.start();
        }

        private void setRetainedSizesProgress(final int offset, final int workunits) {
            final long progressId = HeapProgress.getProgressId();
            this.timer = new Timer(1500, new ActionListener(){
                boolean switchedToDeterminate;

                @Override
                public void actionPerformed(ActionEvent e) {
                    int value;
                    if (!this.switchedToDeterminate) {
                        handle.switchToDeterminate(workunits);
                        this.switchedToDeterminate = true;
                    }
                    if ((value = HeapProgress.getProgressValue((long)progressId)) >= 0) {
                        handle.progress(value + offset);
                    } else {
                        timer.stop();
                    }
                }
            });
            this.timer.start();
        }

        public void finish() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.handle.finish();
        }
    }
}

