/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PropertyDependenciesValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final Map<String, Map<String, Schema>> propertyDependencies;

    public PropertyDependenciesValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.PROPERTY_DEPENDENCIES, schemaNode, schemaLocation, parentSchema, schemaContext);
        Set properties = schemaNode.properties();
        this.propertyDependencies = new LinkedHashMap<String, Map<String, Schema>>(properties.size());
        for (Map.Entry property : properties) {
            String propertyName = (String)property.getKey();
            SchemaLocation propertySchemaLocation = schemaLocation.append(propertyName);
            Set propertyValues = ((JsonNode)property.getValue()).properties();
            for (Map.Entry propertyValue : propertyValues) {
                Map valueSchemas = this.propertyDependencies.computeIfAbsent(propertyName, key -> new LinkedHashMap());
                valueSchemas.put((String)propertyValue.getKey(), schemaContext.newSchema(propertySchemaLocation.append((String)propertyValue.getKey()), (JsonNode)propertyValue.getValue(), parentSchema));
            }
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        this.validate(executionContext, node, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean walk) {
        Set properties = node.properties();
        for (Map.Entry property : properties) {
            Map<String, Schema> propertySchemas;
            String propertyName = (String)property.getKey();
            String propertyValue = ((JsonNode)property.getValue()).asText();
            if (propertyValue == null || (propertySchemas = this.propertyDependencies.get(propertyName)) == null) continue;
            executionContext.evaluationPathAddLast(propertyName);
            try {
                Schema schema = propertySchemas.get(propertyValue);
                if (schema == null) continue;
                executionContext.evaluationPathAddLast(propertyValue);
                try {
                    if (!walk) {
                        schema.validate(executionContext, node, rootNode, instanceLocation);
                        continue;
                    }
                    schema.walk(executionContext, node, rootNode, instanceLocation, true);
                }
                finally {
                    executionContext.evaluationPathRemoveLast();
                }
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            this.validate(executionContext, node, rootNode, instanceLocation, true);
            return;
        }
        for (Map.Entry<String, Map<String, Schema>> property : this.propertyDependencies.entrySet()) {
            String propertyName = property.getKey();
            executionContext.evaluationPathAddLast(propertyName);
            try {
                for (Map.Entry<String, Schema> propertyValue : property.getValue().entrySet()) {
                    executionContext.evaluationPathAddLast(propertyValue.getKey());
                    try {
                        propertyValue.getValue().walk(executionContext, node, rootNode, instanceLocation, false);
                    }
                    finally {
                        executionContext.evaluationPathRemoveLast();
                    }
                }
            }
            finally {
                executionContext.evaluationPathRemoveLast();
            }
        }
    }

    @Override
    public void preloadSchema() {
        for (Map<String, Schema> properties : this.propertyDependencies.values()) {
            for (Schema schema : properties.values()) {
                schema.initializeValidators();
            }
        }
    }
}

