/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.xml.util.XmlStringUtil;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public final class RegExpReplacementUtil {
    private static final String DUMMY = "a";

    private RegExpReplacementUtil() {
    }

    public static void replaceInContext(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            RegExpReplacementUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            RegExpReplacementUtil.$$$reportNull$$$0(1);
        }
        RegExpReplacementUtil.replaceInContext(element, text, null);
    }

    public static void replaceInContext(@NotNull PsiElement element, @NotNull String text, TextRange range) {
        if (element == null) {
            RegExpReplacementUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            RegExpReplacementUtil.$$$reportNull$$$0(3);
        }
        PsiFile file = element.getContainingFile();
        text = RegExpReplacementUtil.escapeForContext(text, file);
        Document document = file.getViewProvider().getDocument();
        assert (document != null);
        TextRange replaceRange = element.getTextRange();
        int startOffset = replaceRange.getStartOffset();
        if (range != null) {
            document.replaceString(startOffset + range.getStartOffset(), startOffset + range.getEndOffset(), (CharSequence)text);
        } else {
            document.replaceString(startOffset, replaceRange.getEndOffset(), (CharSequence)text);
        }
    }

    private static String escapeForContext(String text, PsiFile file) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)file.getProject());
        if (injectedLanguageManager.isInjectedFragment(file)) {
            PsiElement copy;
            PsiElement newElement;
            ElementManipulator manipulator;
            PsiElement context = file.getContext();
            ElementManipulator elementManipulator = manipulator = context == null ? null : ElementManipulators.getManipulator((PsiElement)context);
            if (manipulator != null && (newElement = manipulator.handleContentChange(copy = context.copy(), DUMMY + text)) != null) {
                String newElementText = newElement.getText();
                TextRange newRange = manipulator.getRangeInElement(newElement);
                return newElementText.substring(newRange.getStartOffset() + DUMMY.length(), newRange.getEndOffset());
            }
            if (RegExpElementImpl.isLiteralExpression(context)) {
                return StringUtil.escapeStringCharacters((String)text);
            }
            if (context instanceof XmlElement) {
                return XmlStringUtil.escapeString((String)text);
            }
        }
        return text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/regexp/inspection/RegExpReplacementUtil";
        objectArray[2] = "replaceInContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

