/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.module.scala.deser.IntMapDeserializerResolver$;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.IntMap;
import scala.collection.immutable.IntMap$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class IntMapDeserializerResolver {
    public static JsonDeserializer<?> findArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findArrayDeserializer(arrayType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
    }

    public static JsonDeserializer<?> findBeanDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }

    public static JsonDeserializer<?> findCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findCollectionDeserializer(collectionType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
    }

    public static JsonDeserializer<?> findCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findCollectionLikeDeserializer(collectionLikeType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
    }

    public static JsonDeserializer<?> findEnumDeserializer(Class<?> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findEnumDeserializer(clazz, deserializationConfig, beanDescription);
    }

    public static JsonDeserializer<?> findMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findMapDeserializer(mapType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
    }

    public static JsonDeserializer<?> findMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return IntMapDeserializerResolver$.MODULE$.findMapLikeDeserializer(mapLikeType, deserializationConfig, beanDescription, keyDeserializer, typeDeserializer, jsonDeserializer);
    }

    public static JsonDeserializer<?> findReferenceDeserializer(ReferenceType referenceType, DeserializationConfig deserializationConfig, BeanDescription beanDescription, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findReferenceDeserializer(referenceType, deserializationConfig, beanDescription, typeDeserializer, jsonDeserializer);
    }

    public static JsonDeserializer<?> findTreeNodeDeserializer(Class<? extends JsonNode> clazz, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        return IntMapDeserializerResolver$.MODULE$.findTreeNodeDeserializer(clazz, deserializationConfig, beanDescription);
    }

    public static boolean hasDeserializerFor(DeserializationConfig deserializationConfig, Class<?> clazz) {
        return IntMapDeserializerResolver$.MODULE$.hasDeserializerFor(deserializationConfig, clazz);
    }

    public static class BuilderWrapper
    extends AbstractMap<Object, Object> {
        private IntMap baseMap = IntMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));

        public IntMap<Object> baseMap() {
            return this.baseMap;
        }

        public void baseMap_$eq(IntMap<Object> x$1) {
            this.baseMap = x$1;
        }

        @Override
        public Object put(Object k, Object v) {
            String string;
            Object object = k;
            if (object instanceof Number) {
                Number n = (Number)object;
                int i = n.intValue();
                Option oldValue = this.baseMap().get(i);
                Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i));
                this.baseMap_$eq((IntMap<Object>)this.baseMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, v)));
                return oldValue.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (object instanceof String) {
                String s = (String)object;
                int i = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s));
                Option oldValue = this.baseMap().get(i);
                Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i));
                this.baseMap_$eq((IntMap<Object>)this.baseMap().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, v)));
                return oldValue.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            Option option = Option$.MODULE$.apply(k);
            if (option instanceof Some) {
                Object n = ((Some)option).value();
                string = n.getClass().getName();
            } else {
                string = "null";
            }
            String typeName = string;
            throw new IllegalArgumentException(new StringBuilder(37).append("IntMap does not support keys of type ").append(typeName).toString());
        }

        @Override
        public Object get(Object key) {
            Object object = key;
            if (object instanceof Number) {
                Number n = (Number)object;
                return this.baseMap().get(n.intValue()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (object instanceof String) {
                String s = (String)object;
                return this.baseMap().get(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return ((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.baseMap()).asJava()).entrySet();
        }

        public <V> IntMap<V> asIntMap() {
            return this.baseMap();
        }
    }

    public static class IntMapDeserializer<V>
    extends ContainerDeserializerBase<IntMap<V>>
    implements ContextualDeserializer {
        private final MapLikeType mapType;
        private final MapDeserializer containerDeserializer;

        public IntMapDeserializer(MapLikeType mapType, MapDeserializer containerDeserializer) {
            this.mapType = mapType;
            this.containerDeserializer = containerDeserializer;
            super((JavaType)mapType);
        }

        public JavaType getContentType() {
            return this.containerDeserializer.getContentType();
        }

        public JsonDeserializer<Object> getContentDeserializer() {
            return this.containerDeserializer.getContentDeserializer();
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            MapDeserializer newDelegate = (MapDeserializer)this.containerDeserializer.createContextual(ctxt, property);
            return new IntMapDeserializer<V>(this.mapType, newDelegate);
        }

        public IntMap<V> deserialize(JsonParser jp, DeserializationContext ctxt) {
            Map map = this.containerDeserializer.deserialize(jp, ctxt);
            if (map instanceof BuilderWrapper) {
                BuilderWrapper wrapper = (BuilderWrapper)map;
                return wrapper.asIntMap();
            }
            throw new MatchError((Object)map);
        }

        public IntMap<V> deserialize(JsonParser jp, DeserializationContext ctxt, IntMap<V> intoValue) {
            IntMap<V> newMap = this.deserialize(jp, ctxt);
            if (newMap.isEmpty()) {
                return intoValue;
            }
            return intoValue.$plus$plus(newMap);
        }

        public Object getEmptyValue(DeserializationContext ctxt) {
            return IntMap$.MODULE$.empty();
        }
    }

    public static class IntMapInstantiator
    extends StdValueInstantiator {
        public IntMapInstantiator(DeserializationConfig config, MapLikeType mapType) {
            super(config, (JavaType)mapType);
        }

        public boolean canCreateUsingDefault() {
            return true;
        }

        public Object createUsingDefault(DeserializationContext ctxt) {
            return new BuilderWrapper();
        }
    }
}

