/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.securityanalytics.model.Detector;
import org.opensearch.securityanalytics.model.Value;
import org.opensearch.securityanalytics.rules.aggregation.AggregationItem;
import org.opensearch.securityanalytics.rules.backend.OSQueryBackend;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.objects.SigmaCondition;
import org.opensearch.securityanalytics.rules.objects.SigmaRule;

public class Rule
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(Rule.class);
    public static final String CATEGORY = "category";
    public static final String TITLE = "title";
    public static final String LOG_SOURCE = "log_source";
    public static final String DESCRIPTION = "description";
    public static final String TAGS = "tags";
    public static final String REFERENCES = "references";
    public static final String LEVEL = "level";
    public static final String FALSE_POSITIVES = "false_positives";
    public static final String AUTHOR = "author";
    public static final String STATUS = "status";
    private static final String QUERIES = "queries";
    public static final String QUERY_FIELD_NAMES = "query_field_names";
    public static final String RULE = "rule";
    public static final String PRE_PACKAGED_RULES_INDEX = ".opensearch-sap-pre-packaged-rules-config";
    public static final String CUSTOM_RULES_INDEX = ".opensearch-sap-custom-rules-config";
    public static final String AGGREGATION_QUERIES = "aggregationQueries";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(Rule.class, new ParseField("category", new String[0]), xcp -> Rule.parse(xcp, null, null));
    private String id;
    private Long version;
    private String title;
    private String category;
    private String logSource;
    private String description;
    private List<Value> references;
    private List<Value> tags;
    private String level;
    private List<Value> falsePositives;
    private String author;
    private String status;
    private Instant date;
    private List<Value> queries;
    private List<Value> queryFieldNames;
    private String rule;
    private List<Value> aggregationQueries;

    public Rule(String id, Long version, String title, String category, String logSource, String description, List<Value> references, List<Value> tags, String level, List<Value> falsePositives, String author, String status, Instant date, List<Value> queries, List<Value> queryFieldNames, String rule, List<Value> aggregationQueries) {
        this.id = id != null ? id : "";
        this.version = version != null ? version : Detector.NO_VERSION;
        this.title = title;
        this.category = category;
        this.logSource = logSource;
        this.description = description;
        this.references = references;
        this.tags = tags;
        this.level = level;
        this.falsePositives = falsePositives;
        this.author = author;
        this.status = status;
        this.date = date;
        this.queries = queries;
        this.queryFieldNames = queryFieldNames;
        this.rule = rule;
        this.aggregationQueries = aggregationQueries;
    }

    public Rule(String id, Long version, SigmaRule rule, String category, List<Object> queries, List<String> queryFieldNames, String original) {
        this(id, version, rule.getTitle(), category, rule.getLogSource().getCategory() != null ? rule.getLogSource().getCategory() : (rule.getLogSource().getProduct() != null ? rule.getLogSource().getProduct() : rule.getLogSource().getService()), rule.getDescription(), rule.getReferences().stream().map(Value::new).collect(Collectors.toList()), rule.getTags().stream().map(ruleTag -> new Value(String.format(Locale.getDefault(), "%s.%s", ruleTag.getNamespace(), ruleTag.getName()))).collect(Collectors.toList()), rule.getLevel().toString(), rule.getFalsePositives().stream().map(Value::new).collect(Collectors.toList()), rule.getAuthor(), rule.getStatus().toString(), Instant.ofEpochMilli(rule.getDate().getTime()), queries.stream().filter(query -> !(query instanceof OSQueryBackend.AggregationQueries)).map(query -> new Value(query.toString())).collect(Collectors.toList()), queryFieldNames.stream().map(Value::new).collect(Collectors.toList()), original, queries.stream().filter(query -> query instanceof OSQueryBackend.AggregationQueries).map(it -> new Value(it.toString())).collect(Collectors.toList()));
    }

    public Rule(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), sin.readString(), sin.readString(), sin.readString(), sin.readString(), sin.readList(Value::readFrom), sin.readList(Value::readFrom), sin.readString(), sin.readList(Value::readFrom), sin.readString(), sin.readString(), sin.readInstant(), sin.readList(Value::readFrom), sin.readList(Value::readFrom), sin.readString(), sin.readList(Value::readFrom));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeString(this.title);
        out.writeString(this.category);
        out.writeString(this.logSource);
        out.writeString(this.description);
        out.writeCollection(this.references);
        out.writeCollection(this.tags);
        out.writeString(this.level);
        out.writeCollection(this.falsePositives);
        out.writeString(this.author);
        out.writeString(this.status);
        out.writeInstant(this.date);
        out.writeCollection(this.queries);
        out.writeCollection(this.queryFieldNames);
        out.writeString(this.rule);
        out.writeCollection(this.aggregationQueries);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.createXContentBuilder(builder, params);
    }

    private XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(RULE);
        }
        builder.field(CATEGORY, this.category).field(TITLE, this.title).field(LOG_SOURCE, this.logSource).field(DESCRIPTION, this.description);
        Value[] refArray = new Value[]{};
        refArray = this.references.toArray(refArray);
        builder.field(REFERENCES, (Object)refArray);
        Value[] tagArray = new Value[]{};
        tagArray = this.tags.toArray(tagArray);
        builder.field(TAGS, (Object)tagArray);
        builder.field(LEVEL, this.level);
        Value[] falsePosArray = new Value[]{};
        falsePosArray = this.falsePositives.toArray(falsePosArray);
        builder.field(FALSE_POSITIVES, (Object)falsePosArray);
        builder.field(AUTHOR, this.author);
        builder.field(STATUS, this.status);
        builder.timeField("last_update_time", (Object)this.date);
        Value[] queryArray = new Value[]{};
        queryArray = this.queries.toArray(queryArray);
        builder.field(QUERIES, (Object)queryArray);
        Value[] queryFieldNamesArray = new Value[]{};
        queryFieldNamesArray = this.queryFieldNames.toArray(queryFieldNamesArray);
        builder.field(QUERY_FIELD_NAMES, (Object)queryFieldNamesArray);
        Value[] aggregationsArray = new Value[]{};
        aggregationsArray = this.aggregationQueries.toArray(aggregationsArray);
        builder.field(AGGREGATION_QUERIES, (Object)aggregationsArray);
        builder.field(RULE, this.rule);
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public static Rule docParse(XContentParser xcp, String id, Long version) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        Rule rule = Rule.parse(xcp, id, version);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        rule.setId(id);
        rule.setVersion(version);
        return rule;
    }

    public static Rule parse(XContentParser xcp, String id, Long version) throws IOException {
        if (id == null) {
            id = "";
        }
        if (version == null) {
            version = Detector.NO_VERSION;
        }
        String title = null;
        String category = null;
        String logSource = null;
        String description = null;
        ArrayList<Value> references = new ArrayList<Value>();
        ArrayList<Value> tags = new ArrayList<Value>();
        String level = null;
        ArrayList<Value> falsePositives = new ArrayList<Value>();
        String author = null;
        String status = null;
        Instant date = null;
        ArrayList<Value> queries = new ArrayList<Value>();
        ArrayList<Value> queryFields = new ArrayList<Value>();
        String original = null;
        ArrayList<Value> aggregationQueries = new ArrayList<Value>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block34: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "title": {
                    title = xcp.text();
                    continue block34;
                }
                case "category": {
                    category = xcp.text();
                    continue block34;
                }
                case "log_source": {
                    logSource = xcp.text();
                    continue block34;
                }
                case "description": {
                    description = xcp.text();
                    continue block34;
                }
                case "references": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        references.add(Value.parse(xcp));
                    }
                    continue block34;
                }
                case "tags": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        tags.add(Value.parse(xcp));
                    }
                    continue block34;
                }
                case "level": {
                    level = xcp.text();
                    continue block34;
                }
                case "false_positives": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        falsePositives.add(Value.parse(xcp));
                    }
                    continue block34;
                }
                case "author": {
                    author = xcp.text();
                    continue block34;
                }
                case "status": {
                    status = xcp.text();
                    continue block34;
                }
                case "last_update_time": {
                    date = Instant.parse(xcp.text());
                    continue block34;
                }
                case "queries": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        queries.add(Value.parse(xcp));
                    }
                    continue block34;
                }
                case "query_field_names": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        queryFields.add(Value.parse(xcp));
                    }
                    continue block34;
                }
                case "rule": {
                    original = xcp.text();
                    continue block34;
                }
                case "aggregationQueries": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        aggregationQueries.add(Value.parse(xcp));
                    }
                    break;
                }
            }
            xcp.skipChildren();
        }
        return new Rule(id, version, Objects.requireNonNull(title, "Rule Title is null"), Objects.requireNonNull(category, "Rule Category is null"), Objects.requireNonNull(logSource, "Rule LogSource is null"), description, references, tags, level, falsePositives, author, status, date, queries, queryFields, Objects.requireNonNull(original, "Rule String is null"), aggregationQueries);
    }

    public static Rule readFrom(StreamInput sin) throws IOException {
        return new Rule(sin);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public String getCategory() {
        return this.category;
    }

    public String getTitle() {
        return this.title;
    }

    public String getLogSource() {
        return this.logSource;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Value> getTags() {
        return this.tags;
    }

    public List<Value> getReferences() {
        return this.references;
    }

    public String getLevel() {
        return this.level;
    }

    public List<Value> getFalsePositives() {
        return this.falsePositives;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getStatus() {
        return this.status;
    }

    public Instant getDate() {
        return this.date;
    }

    public String getRule() {
        return this.rule;
    }

    public List<Value> getQueries() {
        return this.queries;
    }

    public List<Value> getQueryFieldNames() {
        return this.queryFieldNames;
    }

    public List<Value> getAggregationQueries() {
        return this.aggregationQueries;
    }

    public boolean isAggregationRule() {
        return this.aggregationQueries != null && !this.aggregationQueries.isEmpty();
    }

    public List<AggregationItem> getAggregationItemsFromRule() throws SigmaConditionError {
        SigmaRule sigmaRule = SigmaRule.fromYaml(this.rule, true);
        ArrayList<AggregationItem> aggregationItems = new ArrayList<AggregationItem>();
        for (SigmaCondition condition : sigmaRule.getDetection().getParsedCondition()) {
            Pair<ConditionItem, AggregationItem> parsedItems = condition.parsed();
            AggregationItem aggItem = (AggregationItem)parsedItems.getRight();
            aggItem.setTimeframe(sigmaRule.getDetection().getTimeframe());
            aggregationItems.add(aggItem);
        }
        return aggregationItems;
    }
}

