/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opensearch.Version;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

public class OperationStats
implements Writeable,
ToXContentFragment {
    private final long count;
    private final long totalTime;
    private final long current;
    private final long failedCount;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private final Map<TimeUnit, String> TIME_UNIT_TO_FIELD_NAME_MAP = Map.of(TimeUnit.NANOSECONDS, "time_in_nanos", TimeUnit.MICROSECONDS, "time_in_micros", TimeUnit.MILLISECONDS, "time_in_millis");

    public OperationStats(long count, long totalTime, long current, long failedCount) {
        this.count = count;
        this.totalTime = totalTime;
        this.current = current;
        this.failedCount = failedCount;
    }

    public OperationStats(long count, long totalTime, long current, long failedCount, TimeUnit timeUnit) {
        this(count, totalTime, current, failedCount);
        this.timeUnit = timeUnit;
    }

    public OperationStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        this.totalTime = in.readVLong();
        this.current = in.readVLong();
        this.failedCount = in.readVLong();
        if (in.getVersion().onOrAfter(Version.V_3_3_0)) {
            this.timeUnit = (TimeUnit)in.readEnum(TimeUnit.class);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        out.writeVLong(this.totalTime);
        out.writeVLong(this.current);
        out.writeVLong(this.failedCount);
        if (out.getVersion().onOrAfter(Version.V_3_3_0)) {
            out.writeEnum((Enum)this.timeUnit);
        }
    }

    public long getCount() {
        return this.count;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getFailedCount() {
        return this.failedCount;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("count", this.count).humanReadableField(this.TIME_UNIT_TO_FIELD_NAME_MAP.get((Object)this.timeUnit), "time", (Object)new TimeValue(this.totalTime, this.timeUnit)).field("current", this.current).field("failed", this.failedCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationStats that = (OperationStats)o;
        return Objects.equals(this.count, that.count) && Objects.equals(this.totalTime, that.totalTime) && Objects.equals(this.failedCount, that.failedCount) && Objects.equals(this.current, that.current);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.totalTime, this.failedCount, this.current);
    }
}

