/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.action.top_queries;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.plugin.insights.rules.model.SearchQueryRecord;

public class TopQueries
extends BaseNodeResponse
implements ToXContentObject {
    private final List<SearchQueryRecord> topQueriesRecords;

    public TopQueries(StreamInput in) throws IOException {
        super(in);
        this.topQueriesRecords = in.readList(SearchQueryRecord::new);
    }

    public TopQueries(DiscoveryNode node, List<SearchQueryRecord> searchQueryRecords) {
        super(node);
        this.topQueriesRecords = searchQueryRecords;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.topQueriesRecords != null) {
            for (SearchQueryRecord record : this.topQueriesRecords) {
                record.toXContent(builder, params);
            }
        }
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.topQueriesRecords);
    }

    public List<SearchQueryRecord> getTopQueriesRecord() {
        return this.topQueriesRecords;
    }
}

