/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.persistent;

import java.io.Closeable;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.NotClusterManagerException;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterManagerTask;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractAsyncTask;
import org.opensearch.core.action.ActionListener;
import org.opensearch.persistent.PersistentTaskParams;
import org.opensearch.persistent.PersistentTaskState;
import org.opensearch.persistent.PersistentTasksCustomMetadata;
import org.opensearch.persistent.PersistentTasksExecutor;
import org.opensearch.persistent.PersistentTasksExecutorRegistry;
import org.opensearch.persistent.decider.AssignmentDecision;
import org.opensearch.persistent.decider.EnableAssignmentDecider;
import org.opensearch.threadpool.ThreadPool;

public class PersistentTasksClusterService
implements ClusterStateListener,
Closeable {
    public static final Setting<TimeValue> CLUSTER_TASKS_ALLOCATION_RECHECK_INTERVAL_SETTING = Setting.timeSetting("cluster.persistent_tasks.allocation.recheck_interval", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)10L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(PersistentTasksClusterService.class);
    private final ClusterService clusterService;
    private final PersistentTasksExecutorRegistry registry;
    private final EnableAssignmentDecider decider;
    private final ThreadPool threadPool;
    private final PeriodicRechecker periodicRechecker;
    private final ClusterManagerTaskThrottler.ThrottlingKey createPersistentTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey finishPersistentTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey removePersistentTaskKey;
    private final ClusterManagerTaskThrottler.ThrottlingKey updatePersistentTaskKey;

    public PersistentTasksClusterService(Settings settings, PersistentTasksExecutorRegistry registry, ClusterService clusterService, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.registry = registry;
        this.decider = new EnableAssignmentDecider(settings, clusterService.getClusterSettings());
        this.threadPool = threadPool;
        this.periodicRechecker = new PeriodicRechecker(CLUSTER_TASKS_ALLOCATION_RECHECK_INTERVAL_SETTING.get(settings));
        if (DiscoveryNode.isClusterManagerNode(settings)) {
            clusterService.addListener(this);
        }
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CLUSTER_TASKS_ALLOCATION_RECHECK_INTERVAL_SETTING, this::setRecheckInterval);
        this.createPersistentTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.CREATE_PERSISTENT_TASK, true);
        this.finishPersistentTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.FINISH_PERSISTENT_TASK, true);
        this.removePersistentTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.REMOVE_PERSISTENT_TASK, true);
        this.updatePersistentTaskKey = clusterService.registerClusterManagerTask(ClusterManagerTask.UPDATE_TASK_STATE, true);
    }

    public void setRecheckInterval(TimeValue recheckInterval) {
        this.periodicRechecker.setInterval(recheckInterval);
    }

    PeriodicRechecker getPeriodicRechecker() {
        return this.periodicRechecker;
    }

    @Override
    public void close() {
        this.periodicRechecker.close();
    }

    public <Params extends PersistentTaskParams> void createPersistentTask(final String taskId, final String taskName, final Params taskParams, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.clusterService.submitStateUpdateTask("create persistent task", new ClusterStateUpdateTask(this){
            final /* synthetic */ PersistentTasksClusterService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                PersistentTasksCustomMetadata.Builder builder = PersistentTasksClusterService.builder(currentState);
                if (builder.hasTask(taskId)) {
                    throw new ResourceAlreadyExistsException("task with id {" + taskId + "} already exist", new Object[0]);
                }
                PersistentTasksExecutor<PersistentTaskParams> taskExecutor = this.this$0.registry.getPersistentTaskExecutorSafe(taskName);
                taskExecutor.validate(taskParams, currentState);
                PersistentTasksCustomMetadata.Assignment assignment = this.this$0.createAssignment(taskName, taskParams, currentState);
                return PersistentTasksClusterService.update(currentState, builder.addTask(taskId, taskName, taskParams, assignment));
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.createPersistentTaskKey;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)newState.getMetadata().custom("persistent_tasks");
                if (tasks != null) {
                    PersistentTasksCustomMetadata.PersistentTask<?> task = tasks.getTask(taskId);
                    listener.onResponse(task);
                    if (task != null && !task.isAssigned() && !this.this$0.periodicRechecker.isScheduled()) {
                        this.this$0.periodicRechecker.rescheduleIfNecessary();
                    }
                } else {
                    listener.onResponse(null);
                }
            }
        });
    }

    public void completePersistentTask(final String id, final long allocationId, Exception failure, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        String source;
        if (failure != null) {
            logger.warn("persistent task " + id + " failed", (Throwable)failure);
            source = "finish persistent task (failed)";
        } else {
            source = "finish persistent task (success)";
        }
        this.clusterService.submitStateUpdateTask(source, new ClusterStateUpdateTask(this){
            final /* synthetic */ PersistentTasksClusterService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                PersistentTasksCustomMetadata.Builder tasksInProgress = PersistentTasksClusterService.builder(currentState);
                if (tasksInProgress.hasTask(id, allocationId)) {
                    tasksInProgress.removeTask(id);
                    return PersistentTasksClusterService.update(currentState, tasksInProgress);
                }
                if (tasksInProgress.hasTask(id)) {
                    logger.warn("The task [{}] with id [{}] was found but it has a different allocation id [{}], status is not updated", (Object)PersistentTasksCustomMetadata.getTaskWithId(currentState, id).getTaskName(), (Object)id, (Object)allocationId);
                } else {
                    logger.warn("The task [{}] wasn't found, status is not updated", (Object)id);
                }
                throw new ResourceNotFoundException("the task with id [" + id + "] and allocation id [" + allocationId + "] not found", new Object[0]);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.finishPersistentTaskKey;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(PersistentTasksCustomMetadata.getTaskWithId(oldState, id));
            }
        });
    }

    public void removePersistentTask(final String id, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.clusterService.submitStateUpdateTask("remove persistent task", new ClusterStateUpdateTask(this){
            final /* synthetic */ PersistentTasksClusterService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                PersistentTasksCustomMetadata.Builder tasksInProgress = PersistentTasksClusterService.builder(currentState);
                if (tasksInProgress.hasTask(id)) {
                    return PersistentTasksClusterService.update(currentState, tasksInProgress.removeTask(id));
                }
                throw new ResourceNotFoundException("the task with id {} doesn't exist", id);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.removePersistentTaskKey;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(PersistentTasksCustomMetadata.getTaskWithId(oldState, id));
            }
        });
    }

    public void updatePersistentTaskState(final String taskId, final long taskAllocationId, final PersistentTaskState taskState, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.clusterService.submitStateUpdateTask("update task state [" + taskId + "]", new ClusterStateUpdateTask(this){
            final /* synthetic */ PersistentTasksClusterService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                PersistentTasksCustomMetadata.Builder tasksInProgress = PersistentTasksClusterService.builder(currentState);
                if (tasksInProgress.hasTask(taskId, taskAllocationId)) {
                    return PersistentTasksClusterService.update(currentState, tasksInProgress.updateTaskState(taskId, taskState));
                }
                if (tasksInProgress.hasTask(taskId)) {
                    logger.warn("trying to update state on task {} with unexpected allocation id {}", (Object)taskId, (Object)taskAllocationId);
                } else {
                    logger.warn("trying to update state on non-existing task {}", (Object)taskId);
                }
                throw new ResourceNotFoundException("the task with id {} and allocation id {} doesn't exist", taskId, taskAllocationId);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return this.this$0.updatePersistentTaskKey;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(PersistentTasksCustomMetadata.getTaskWithId(newState, taskId));
            }
        });
    }

    public void unassignPersistentTask(final String taskId, final long taskAllocationId, final String reason, final ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>> listener) {
        this.clusterService.submitStateUpdateTask("unassign persistent task from any node", new ClusterStateUpdateTask(this){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                PersistentTasksCustomMetadata.Builder tasksInProgress = PersistentTasksClusterService.builder(currentState);
                if (tasksInProgress.hasTask(taskId, taskAllocationId)) {
                    logger.trace("Unassigning task {} with allocation id {}", (Object)taskId, (Object)taskAllocationId);
                    return PersistentTasksClusterService.update(currentState, tasksInProgress.reassignTask(taskId, PersistentTasksClusterService.unassignedAssignment(reason)));
                }
                throw new ResourceNotFoundException("the task with id {} and allocation id {} doesn't exist", taskId, taskAllocationId);
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(PersistentTasksCustomMetadata.getTaskWithId(newState, taskId));
            }
        });
    }

    private <Params extends PersistentTaskParams> PersistentTasksCustomMetadata.Assignment createAssignment(String taskName, Params taskParams, ClusterState currentState) {
        PersistentTasksExecutor<Params> persistentTasksExecutor = this.registry.getPersistentTaskExecutorSafe(taskName);
        AssignmentDecision decision = this.decider.canAssign();
        if (decision.getType() == AssignmentDecision.Type.NO) {
            return PersistentTasksClusterService.unassignedAssignment("persistent task [" + taskName + "] cannot be assigned [" + decision.getReason() + "]");
        }
        return persistentTasksExecutor.getAssignment(taskParams, currentState);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeClusterManager()) {
            if (this.shouldReassignPersistentTasks(event)) {
                this.periodicRechecker.cancel();
                logger.trace("checking task reassignment for cluster state {}", (Object)event.state().getVersion());
                this.reassignPersistentTasks();
            }
        } else {
            this.periodicRechecker.cancel();
        }
    }

    private void reassignPersistentTasks() {
        this.clusterService.submitStateUpdateTask("reassign persistent tasks", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return PersistentTasksClusterService.this.reassignTasks(currentState);
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.warn("failed to reassign persistent tasks", (Throwable)e);
                if (!(e instanceof NotClusterManagerException)) {
                    PersistentTasksClusterService.this.periodicRechecker.rescheduleIfNecessary();
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (PersistentTasksClusterService.this.isAnyTaskUnassigned((PersistentTasksCustomMetadata)newState.getMetadata().custom("persistent_tasks"))) {
                    PersistentTasksClusterService.this.periodicRechecker.rescheduleIfNecessary();
                }
            }
        });
    }

    boolean shouldReassignPersistentTasks(ClusterChangedEvent event) {
        boolean masterChanged;
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)event.state().getMetadata().custom("persistent_tasks");
        if (tasks == null) {
            return false;
        }
        boolean bl = masterChanged = !event.previousState().nodes().isLocalNodeElectedClusterManager();
        if (PersistentTasksClusterService.persistentTasksChanged(event) || event.nodesChanged() || event.routingTableChanged() || event.metadataChanged() || masterChanged) {
            for (PersistentTasksCustomMetadata.PersistentTask<?> task : tasks.tasks()) {
                PersistentTasksCustomMetadata.Assignment assignment;
                if (!PersistentTasksClusterService.needsReassignment(task.getAssignment(), event.state().nodes()) || Objects.equals(assignment = this.createAssignment(task.getTaskName(), (PersistentTaskParams)task.getParams(), event.state()), task.getAssignment())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAnyTaskUnassigned(PersistentTasksCustomMetadata tasks) {
        return tasks != null && tasks.tasks().stream().anyMatch(task -> !task.getAssignment().isAssigned());
    }

    ClusterState reassignTasks(ClusterState currentState) {
        ClusterState clusterState = currentState;
        PersistentTasksCustomMetadata tasks = (PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks");
        if (tasks != null) {
            logger.trace("reassigning {} persistent tasks", (Object)tasks.tasks().size());
            DiscoveryNodes nodes = currentState.nodes();
            for (PersistentTasksCustomMetadata.PersistentTask<?> task : tasks.tasks()) {
                if (PersistentTasksClusterService.needsReassignment(task.getAssignment(), nodes)) {
                    PersistentTasksCustomMetadata.Assignment assignment = this.createAssignment(task.getTaskName(), (PersistentTaskParams)task.getParams(), clusterState);
                    if (!Objects.equals(assignment, task.getAssignment())) {
                        logger.trace("reassigning task {} from node {} to node {}", (Object)task.getId(), (Object)task.getAssignment().getExecutorNode(), (Object)assignment.getExecutorNode());
                        clusterState = PersistentTasksClusterService.update(clusterState, PersistentTasksClusterService.builder(clusterState).reassignTask(task.getId(), assignment));
                        continue;
                    }
                    logger.trace("ignoring task {} because assignment is the same {}", (Object)task.getId(), (Object)assignment);
                    continue;
                }
                logger.trace("ignoring task {} because it is still running", (Object)task.getId());
            }
        }
        return clusterState;
    }

    static boolean persistentTasksChanged(ClusterChangedEvent event) {
        String type = "persistent_tasks";
        return !Objects.equals(event.state().metadata().custom(type), event.previousState().metadata().custom(type));
    }

    public static boolean needsReassignment(PersistentTasksCustomMetadata.Assignment assignment, DiscoveryNodes nodes) {
        return !assignment.isAssigned() || !nodes.nodeExists(assignment.getExecutorNode());
    }

    private static PersistentTasksCustomMetadata.Builder builder(ClusterState currentState) {
        return PersistentTasksCustomMetadata.builder((PersistentTasksCustomMetadata)currentState.getMetadata().custom("persistent_tasks"));
    }

    private static ClusterState update(ClusterState currentState, PersistentTasksCustomMetadata.Builder tasksInProgress) {
        if (tasksInProgress.isChanged()) {
            return ClusterState.builder(currentState).metadata(Metadata.builder(currentState.metadata()).putCustom("persistent_tasks", tasksInProgress.build())).build();
        }
        return currentState;
    }

    private static PersistentTasksCustomMetadata.Assignment unassignedAssignment(String reason) {
        return new PersistentTasksCustomMetadata.Assignment(null, reason);
    }

    class PeriodicRechecker
    extends AbstractAsyncTask {
        PeriodicRechecker(TimeValue recheckInterval) {
            super(logger, PersistentTasksClusterService.this.threadPool, recheckInterval, false);
        }

        @Override
        protected boolean mustReschedule() {
            return true;
        }

        @Override
        public void runInternal() {
            if (PersistentTasksClusterService.this.clusterService.localNode().isClusterManagerNode()) {
                ClusterState state = PersistentTasksClusterService.this.clusterService.state();
                logger.trace("periodic persistent task assignment check running for cluster state {}", (Object)state.getVersion());
                if (PersistentTasksClusterService.this.isAnyTaskUnassigned((PersistentTasksCustomMetadata)state.getMetadata().custom("persistent_tasks"))) {
                    PersistentTasksClusterService.this.reassignPersistentTasks();
                }
            }
        }

        public String toString() {
            return "persistent_task_recheck";
        }
    }
}

