/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs.backward_codecs.lucene912;

import java.util.Set;
import org.apache.lucene.backward_codecs.lucene912.Lucene912Codec;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FilterCodec;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene912.Lucene912CustomStoredFieldsFormat;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99CustomCodec;

public abstract class Lucene912CustomCodec
extends FilterCodec {
    private final StoredFieldsFormat storedFieldsFormat;

    public Lucene912CustomCodec(Mode mode) {
        this(mode, Lucene99CustomCodec.DEFAULT_COMPRESSION_LEVEL);
    }

    public Lucene912CustomCodec(Mode mode, int compressionLevel) {
        super(mode.getCodec(), (Codec)new Lucene912Codec());
        this.storedFieldsFormat = new Lucene912CustomStoredFieldsFormat(mode, compressionLevel);
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static enum Mode {
        ZSTD("ZSTD912", Set.of("zstd")),
        ZSTD_NO_DICT("ZSTDNODICT912", Set.of("zstd_no_dict"));

        private final String codec;
        private final Set<String> aliases;

        private Mode(String codec, Set<String> aliases) {
            this.codec = codec;
            this.aliases = aliases;
        }

        public String getCodec() {
            return this.codec;
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

