/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.common.registry;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.storage.Storage;
import org.openhab.core.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public abstract class AbstractManagedProvider<@NonNull E extends Identifiable<K>, @NonNull K, @NonNull PE>
extends AbstractProvider<E>
implements ManagedProvider<E, K> {
    private volatile Storage<PE> storage;
    protected final Logger logger = LoggerFactory.getLogger(AbstractManagedProvider.class);

    protected AbstractManagedProvider(StorageService storageService) {
        this.storage = storageService.getStorage(this.getStorageName(), this.getClass().getClassLoader());
    }

    @Override
    public void add(E element) {
        String keyAsString = this.getKeyAsString(element);
        if (this.storage.get(keyAsString) != null) {
            throw new IllegalArgumentException("Cannot add element, because an element with same UID (" + keyAsString + ") already exists.");
        }
        this.storage.put(keyAsString, this.toPersistableElement(element));
        this.notifyListenersAboutAddedElement(element);
        this.logger.debug("Added new element {} to {}.", (Object)keyAsString, (Object)this.getClass().getSimpleName());
    }

    @Override
    public Collection<E> getAll() {
        return this.storage.getKeys().stream().map(this::getElement).filter(Objects::nonNull).toList();
    }

    @Override
    public @Nullable E get(K key) {
        return this.getElement(this.keyToString(key));
    }

    private @Nullable E getElement(String key) {
        @Nullable PE persistableElement = this.storage.get(key);
        return persistableElement != null ? (E)this.toElement(key, persistableElement) : null;
    }

    @Override
    public @Nullable E remove(K key) {
        E element;
        String keyAsString = this.keyToString(key);
        @Nullable PE persistableElement = this.storage.remove(keyAsString);
        if (persistableElement != null && (element = this.toElement(keyAsString, persistableElement)) != null) {
            this.notifyListenersAboutRemovedElement(element);
            this.logger.debug("Removed element {} from {}.", (Object)keyAsString, (Object)this.getClass().getSimpleName());
            return element;
        }
        return null;
    }

    @Override
    public @Nullable E update(E element) {
        String key = this.getKeyAsString(element);
        if (this.storage.get(key) != null) {
            @Nullable PE persistableElement = this.storage.put(key, this.toPersistableElement(element));
            if (persistableElement != null) {
                @Nullable E oldElement = this.toElement(key, persistableElement);
                if (oldElement == null) {
                    oldElement = element;
                }
                this.notifyListenersAboutUpdatedElement(oldElement, element);
                this.logger.debug("Updated element {} in {}.", (Object)key, (Object)this.getClass().getSimpleName());
                return oldElement;
            }
        } else {
            this.logger.warn("Could not update element with key {} in {}, because it does not exist.", (Object)key, (Object)this.getClass().getSimpleName());
        }
        return null;
    }

    private String getKeyAsString(E element) {
        return this.keyToString(element.getUID());
    }

    protected abstract String getStorageName();

    protected abstract String keyToString(K var1);

    protected abstract @Nullable E toElement(String var1, PE var2);

    protected abstract PE toPersistableElement(E var1);
}

