/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.util.Optional;
import org.keycloak.vault.VaultStringSecret;

public class DefaultVaultStringSecret
implements VaultStringSecret {
    private static final VaultStringSecret EMPTY_VAULT_SECRET = new VaultStringSecret(){

        public Optional<String> get() {
            return Optional.empty();
        }

        public void close() {
        }
    };
    private String secret;

    public static VaultStringSecret forString(Optional<String> secret) {
        if (secret == null || !secret.isPresent()) {
            return EMPTY_VAULT_SECRET;
        }
        return new DefaultVaultStringSecret(secret.get());
    }

    private DefaultVaultStringSecret(String secret) {
        this.secret = secret;
    }

    public Optional<String> get() {
        return Optional.of(this.secret);
    }

    public void close() {
        this.secret = null;
    }
}

