/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.io.IOException;
import java.net.URI;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.jboss.logging.Logger;
import org.keycloak.connections.httpclient.HttpClientProvider;
import org.keycloak.models.KeycloakSession;

public abstract class OCSPProvider {
    private static final Logger logger = Logger.getLogger(OCSPProvider.class);
    protected static final int TIME_SKEW = 900000;

    public OCSPRevocationStatus check(KeycloakSession session, X509Certificate cert, X509Certificate issuerCertificate, URI responderURI, X509Certificate responderCert, Date date) throws CertPathValidatorException {
        if (cert == null) {
            throw new IllegalArgumentException("cert cannot be null");
        }
        if (issuerCertificate == null) {
            throw new IllegalArgumentException("issuerCertificate cannot be null");
        }
        if (responderURI == null) {
            throw new IllegalArgumentException("responderURI cannot be null");
        }
        return this.check(session, cert, issuerCertificate, Collections.singletonList(responderURI), responderCert, date);
    }

    public OCSPRevocationStatus check(KeycloakSession session, X509Certificate cert, X509Certificate issuerCertificate, Date date, X509Certificate responderCert) throws CertPathValidatorException {
        List<String> responderURIs = null;
        try {
            responderURIs = this.getResponderURIs(cert);
        }
        catch (CertificateEncodingException e) {
            logger.log(Logger.Level.DEBUG, (Object)"CertificateEncodingException: {0}", (Throwable)e);
            throw new CertPathValidatorException(e.getMessage(), e);
        }
        if (responderURIs.size() == 0) {
            logger.log(Logger.Level.INFO, (Object)"No OCSP responders in the specified certificate");
            throw new CertPathValidatorException("No OCSP Responder URI in certificate");
        }
        LinkedList<URI> uris = new LinkedList<URI>();
        for (String value : responderURIs) {
            try {
                URI responderURI = URI.create(value);
                uris.add(responderURI);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Logger.Level.DEBUG, "Malformed responder URI {0}", (Object)value, (Throwable)ex);
            }
        }
        return this.check(session, cert, issuerCertificate, Collections.unmodifiableList(uris), responderCert, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getEncodedOCSPResponse(KeycloakSession session, byte[] encodedOCSPReq, URI responderUri) throws IOException {
        CloseableHttpClient httpClient = ((HttpClientProvider)session.getProvider(HttpClientProvider.class)).getHttpClient();
        HttpPost post = new HttpPost(responderUri);
        post.setHeader("Content-Type", "application/ocsp-request");
        post.setEntity((HttpEntity)new ByteArrayEntity(encodedOCSPReq));
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
            byte[] byArray;
            try {
                byte[] data;
                if (response.getStatusLine().getStatusCode() != 200) {
                    String errorMessage = String.format("Connection error, unable to obtain certificate revocation status using OCSP responder \"%s\", code \"%d\"", responderUri.toString(), response.getStatusLine().getStatusCode());
                    throw new IOException(errorMessage);
                }
                byArray = data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw throwable;
            }
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return byArray;
        }
    }

    public OCSPRevocationStatus check(KeycloakSession session, X509Certificate cert, X509Certificate issuerCertificate) throws CertPathValidatorException {
        return this.check(session, cert, issuerCertificate, null, null);
    }

    protected abstract OCSPRevocationStatus check(KeycloakSession var1, X509Certificate var2, X509Certificate var3, List<URI> var4, X509Certificate var5, Date var6) throws CertPathValidatorException;

    protected static OCSPRevocationStatus unknownStatus() {
        return new OCSPRevocationStatus(){

            @Override
            public RevocationStatus getRevocationStatus() {
                return RevocationStatus.UNKNOWN;
            }

            @Override
            public Date getRevocationTime() {
                return new Date(System.currentTimeMillis());
            }

            @Override
            public CRLReason getRevocationReason() {
                return CRLReason.UNSPECIFIED;
            }
        };
    }

    protected abstract List<String> getResponderURIs(X509Certificate var1) throws CertificateEncodingException;

    public static interface OCSPRevocationStatus {
        public RevocationStatus getRevocationStatus();

        public Date getRevocationTime();

        public CRLReason getRevocationReason();
    }

    public static enum RevocationStatus {
        GOOD,
        REVOKED,
        UNKNOWN;

    }
}

