/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.StartupBuildSteps;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.Shutdown;
import io.quarkus.runtime.ShutdownEvent;
import jakarta.enterprise.context.spi.Contextual;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class ShutdownBuildSteps {
    static final DotName SHUTDOWN_NAME = DotName.createSimple((String)Shutdown.class.getName());
    private static final Logger LOG = Logger.getLogger(ShutdownBuildSteps.class);

    @BuildStep
    AutoAddScopeBuildItem addScope(CustomScopeAnnotationsBuildItem customScopes) {
        return AutoAddScopeBuildItem.builder().defaultScope(BuiltinScope.APPLICATION).anyMethodMatches(new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo m) {
                return m.hasAnnotation(SHUTDOWN_NAME);
            }
        }).reason("Found classes containing @Shutdown annotation.").build();
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableBeans() {
        return new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo bean) {
                if (bean.isClassBean()) {
                    return ((AnnotationTarget)bean.getTarget().get()).asClass().annotationsMap().containsKey(SHUTDOWN_NAME);
                }
                return false;
            }
        });
    }

    @BuildStep
    void registerShutdownObservers(ObserverRegistrationPhaseBuildItem observerRegistration, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> configurators) {
        AnnotationStore annotationStore = (AnnotationStore)observerRegistration.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : observerRegistration.getContext().beans().classBeans()) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            ArrayList<MethodInfo> shutdownMethods = new ArrayList<MethodInfo>();
            for (MethodInfo method : beanClass.methods()) {
                if (!annotationStore.hasAnnotation((AnnotationTarget)method, SHUTDOWN_NAME)) continue;
                if (!(method.isSynthetic() || Modifier.isPrivate(method.flags()) || Modifier.isStatic(method.flags()) || method.parametersCount() != 0)) {
                    shutdownMethods.add(method);
                    continue;
                }
                LOG.warnf("Ignored an invalid @Shutdown method declared on %s: %s", (Object)method.declaringClass().name(), (Object)method);
            }
            if (shutdownMethods.isEmpty()) continue;
            for (MethodInfo method : shutdownMethods) {
                AnnotationValue priority = annotationStore.getAnnotation((AnnotationTarget)method, SHUTDOWN_NAME).value();
                this.registerShutdownObserver(observerRegistration, bean, String.valueOf(method.declaringClass().name()) + "#" + method.toString(), priority != null ? priority.asInt() : 2500, method);
            }
        }
    }

    private void registerShutdownObserver(ObserverRegistrationPhaseBuildItem observerRegistration, BeanInfo bean, String id, int priority, MethodInfo shutdownMethod) {
        ObserverConfigurator configurator = observerRegistration.getContext().configure().beanClass(bean.getBeanClass()).observedType(ShutdownEvent.class);
        configurator.id(id);
        configurator.priority(priority);
        configurator.notify(mc -> {
            ResultHandle containerHandle = mc.invokeStaticMethod(StartupBuildSteps.ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle beanHandle = mc.invokeInterfaceMethod(StartupBuildSteps.ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{mc.load(bean.getIdentifier())});
            if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
                ResultHandle creationalContext = mc.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{beanHandle});
                ResultHandle instance = mc.invokeInterfaceMethod(StartupBuildSteps.CONTEXTUAL_CREATE, beanHandle, new ResultHandle[]{creationalContext});
                TryBlock tryBlock = mc.tryBlock();
                tryBlock.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)shutdownMethod), instance, new ResultHandle[0]);
                CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
                catchBlock.invokeInterfaceMethod(StartupBuildSteps.CONTEXTUAL_DESTROY, beanHandle, new ResultHandle[]{instance, creationalContext});
                catchBlock.throwException(RuntimeException.class, "Error destroying bean with @Shutdown method", catchBlock.getCaughtException());
                mc.invokeInterfaceMethod(StartupBuildSteps.CONTEXTUAL_DESTROY, beanHandle, new ResultHandle[]{instance, creationalContext});
            } else {
                ResultHandle instanceHandle = mc.invokeInterfaceMethod(StartupBuildSteps.ARC_CONTAINER_INSTANCE, containerHandle, new ResultHandle[]{beanHandle});
                ResultHandle instance = mc.invokeInterfaceMethod(StartupBuildSteps.INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]);
                mc.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)shutdownMethod), instance, new ResultHandle[0]);
            }
            mc.returnValue(null);
        });
        configurator.done();
    }
}

