/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.spi.TypeConfiguration;

public final class Template {
    private static final Set<String> KEYWORDS = Set.of("and", "or", "not", "like", "escape", "is", "in", "between", "null", "select", "distinct", "from", "join", "inner", "outer", "left", "right", "on", "where", "having", "group", "order", "by", "desc", "asc", "limit", "any", "some", "exists", "all", "union", "minus", "except", "intersect", "partition");
    private static final Set<String> BEFORE_TABLE_KEYWORDS = Set.of("from", "join");
    private static final Set<String> FUNCTION_KEYWORDS = Set.of("as", "leading", "trailing", "from", "case", "when", "then", "else", "end");
    private static final Set<String> FUNCTION_WITH_FROM_KEYWORDS = Set.of("extract", "trim");
    private static final Set<String> SOFT_KEYWORDS = Set.of("date", "time");
    private static final Set<String> LITERAL_PREFIXES = Set.of("n", "x", "varbyte", "bx", "bytea", "date", "time", "timestamp", "zone");
    private static final String PUNCTUATION = "=><!+-*/()',|&`";
    public static final String TEMPLATE = "{@}";

    private Template() {
    }

    public static String renderTransformerReadFragment(String fragment, String ... columnNames) {
        for (String columnName : columnNames) {
            fragment = fragment.replace(columnName, "{@}." + columnName);
        }
        return fragment;
    }

    public static String renderWhereStringTemplate(String sql, Dialect dialect, TypeConfiguration typeConfiguration) {
        return Template.renderWhereStringTemplate(sql, TEMPLATE, dialect, typeConfiguration);
    }

    public static String renderWhereStringTemplate(String sql, String alias, Dialect dialect, TypeConfiguration typeConfiguration) {
        String symbols = "=><!+-*/()',|&` \n\r\f\t" + dialect.openQuote() + dialect.closeQuote();
        StringTokenizer tokens = new StringTokenizer(sql, symbols, true);
        StringBuilder result = new StringBuilder();
        boolean quoted = false;
        boolean quotedIdentifier = false;
        boolean beforeTable = false;
        boolean inFromClause = false;
        boolean afterFromTable = false;
        boolean inExtractOrTrim = false;
        boolean inCast = false;
        boolean afterCastAs = false;
        boolean hasMore = tokens.hasMoreTokens();
        String nextToken = hasMore ? tokens.nextToken() : null;
        String token = null;
        while (hasMore) {
            boolean quotedOrWhitespace;
            String previousToken = token;
            token = nextToken;
            String lcToken = token.toLowerCase(Locale.ROOT);
            hasMore = tokens.hasMoreTokens();
            nextToken = hasMore ? tokens.nextToken() : null;
            boolean isQuoteCharacter = false;
            if (!quotedIdentifier && "'".equals(token)) {
                quoted = !quoted;
                isQuoteCharacter = true;
            }
            if (!quoted) {
                boolean isOpenQuote;
                if ("`".equals(token)) {
                    isOpenQuote = !quotedIdentifier;
                    lcToken = isOpenQuote ? Character.toString(dialect.openQuote()) : Character.toString(dialect.closeQuote());
                    token = lcToken;
                    quotedIdentifier = isOpenQuote;
                    isQuoteCharacter = true;
                } else if (!quotedIdentifier && dialect.openQuote() == token.charAt(0)) {
                    isOpenQuote = true;
                    quotedIdentifier = true;
                    isQuoteCharacter = true;
                } else if (quotedIdentifier && dialect.closeQuote() == token.charAt(0)) {
                    quotedIdentifier = false;
                    isQuoteCharacter = true;
                    isOpenQuote = false;
                } else {
                    isOpenQuote = false;
                }
                if (isOpenQuote && !inFromClause && !Template.endsWithDot(previousToken)) {
                    result.append(alias).append('.');
                }
            }
            boolean bl = quotedOrWhitespace = quoted || quotedIdentifier || isQuoteCharacter || token.isBlank();
            if (quotedOrWhitespace) {
                result.append(token);
            } else if (beforeTable) {
                result.append(token);
                beforeTable = false;
                afterFromTable = true;
            } else if (afterFromTable) {
                if (!"as".equals(lcToken)) {
                    afterFromTable = false;
                }
                result.append(token);
            } else if (Template.isNamedParameter(token)) {
                result.append(token);
            } else if (FUNCTION_WITH_FROM_KEYWORDS.contains(lcToken) && "(".equals(nextToken)) {
                result.append(token);
                inExtractOrTrim = true;
            } else if ("cast".equals(lcToken)) {
                result.append(token);
                inCast = true;
            } else if (inCast && ("as".equals(lcToken) || afterCastAs)) {
                result.append(token);
                afterCastAs = true;
            } else if (!inFromClause && Template.isIdentifier(token) && !Template.isFunctionOrKeyword(lcToken, nextToken, dialect, typeConfiguration) && !Template.isLiteral(lcToken, nextToken, sql, symbols, tokens)) {
                result.append(alias).append('.').append(dialect.quote(token));
            } else {
                if (")".equals(lcToken)) {
                    inExtractOrTrim = false;
                    inCast = false;
                    afterCastAs = false;
                } else if (!inExtractOrTrim && BEFORE_TABLE_KEYWORDS.contains(lcToken)) {
                    beforeTable = true;
                    inFromClause = true;
                } else if (inFromClause && ",".equals(lcToken)) {
                    beforeTable = true;
                }
                if (Template.isBoolean(token)) {
                    token = dialect.toBooleanValueString(Boolean.parseBoolean(token));
                }
                result.append(token);
            }
            if (!inFromClause || !KEYWORDS.contains(lcToken) || BEFORE_TABLE_KEYWORDS.contains(lcToken)) continue;
            inFromClause = false;
        }
        return result.toString();
    }

    private static boolean endsWithDot(String token) {
        return token != null && token.endsWith(".");
    }

    private static boolean isLiteral(String lcToken, String next, String sqlWhereString, String symbols, StringTokenizer tokens) {
        if (next == null) {
            return false;
        }
        if (LITERAL_PREFIXES.contains(lcToken)) {
            if (next.isBlank()) {
                return Template.lookPastBlankTokens(sqlWhereString, symbols, tokens, 1, nextToken -> "'".equals(nextToken) || lcToken.equals("time") && "with".equals(nextToken) || lcToken.equals("timestamp") && "with".equals(nextToken) || lcToken.equals("time") && "zone".equals(nextToken));
            }
            return "'".equals(next);
        }
        return false;
    }

    private static boolean lookPastBlankTokens(String sqlWhereString, String symbols, StringTokenizer tokens, int skip, Function<String, Boolean> check) {
        StringTokenizer lookahead = Template.lookahead(sqlWhereString, symbols, tokens, skip);
        if (lookahead.hasMoreTokens()) {
            String nextToken;
            while ((nextToken = lookahead.nextToken().toLowerCase(Locale.ROOT)).isBlank() && lookahead.hasMoreTokens()) {
            }
            return check.apply(nextToken);
        }
        return false;
    }

    private static StringTokenizer lookahead(String sql, String symbols, StringTokenizer tokens, int skip) {
        StringTokenizer lookahead = new StringTokenizer(sql, symbols, true);
        while (lookahead.countTokens() > tokens.countTokens() + skip) {
            lookahead.nextToken();
        }
        return lookahead;
    }

    public static List<String> collectColumnNames(String sql, Dialect dialect, TypeConfiguration typeConfiguration) {
        return Template.collectColumnNames(Template.renderWhereStringTemplate(sql, dialect, typeConfiguration));
    }

    public static List<String> collectColumnNames(String template) {
        int match;
        ArrayList<String> names = new ArrayList<String>();
        int begin = 0;
        block0: while ((match = template.indexOf(TEMPLATE, begin)) >= 0) {
            int start;
            int loc = start = match + TEMPLATE.length() + 1;
            while (true) {
                if (loc == template.length() - 1) {
                    names.add(template.substring(start));
                    begin = template.length();
                    continue block0;
                }
                char ch = template.charAt(loc);
                if (PUNCTUATION.indexOf(ch) >= 0 || " \n\r\f\t".indexOf(ch) >= 0) {
                    names.add(template.substring(start, loc));
                    begin = loc;
                    continue block0;
                }
                ++loc;
            }
        }
        return names;
    }

    private static boolean isNamedParameter(String token) {
        return token.startsWith(":");
    }

    private static boolean isFunctionOrKeyword(String lcToken, String nextToken, Dialect dialect, TypeConfiguration typeConfiguration) {
        if ("(".equals(nextToken)) {
            return true;
        }
        if (SOFT_KEYWORDS.contains(lcToken)) {
            return false;
        }
        return KEYWORDS.contains(lcToken) || Template.isType(lcToken, typeConfiguration) || dialect.getKeywords().contains(lcToken) || FUNCTION_KEYWORDS.contains(lcToken);
    }

    private static boolean isType(String lcToken, TypeConfiguration typeConfiguration) {
        return typeConfiguration.getDdlTypeRegistry().isTypeNameRegistered(lcToken);
    }

    private static boolean isIdentifier(String token) {
        return token.charAt(0) == '`' || Character.isLetter(token.charAt(0)) && token.indexOf(46) < 0 && !Template.isBoolean(token);
    }

    private static boolean isBoolean(String token) {
        return switch (token.toLowerCase(Locale.ROOT)) {
            case "true", "false" -> true;
            default -> false;
        };
    }
}

