/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;

public class BinaryRepresentation
extends StandardRepresentation {
    public static final BinaryRepresentation BINARY_REPRESENTATION = new BinaryRepresentation();
    public static final String BYTE_PREFIX = "0b";

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof Character) {
            Character character = (Character)object;
            return this.toStringOf(character);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return this.toStringOf(number);
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.toStringOf(this, string);
        }
        return super.toStringOf(object);
    }

    protected String toStringOf(Representation representation, String s) {
        return Strings.concat("\"", representation.toStringOf(s.toCharArray()), "\"");
    }

    @Override
    protected String toStringOf(Number number) {
        if (number instanceof Byte) {
            Byte b = (Byte)number;
            return this.toStringOf(b);
        }
        if (number instanceof Short) {
            Short s = (Short)number;
            return this.toStringOf(s);
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return this.toStringOf(i);
        }
        if (number instanceof Long) {
            Long l = (Long)number;
            return this.toStringOf(l);
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return this.toStringOf(f);
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            return this.toStringOf(d);
        }
        return number == null ? null : number.toString();
    }

    protected String toStringOf(Byte b) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(b & 0xFF), 8);
    }

    protected String toStringOf(Short s) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(s & 0xFFFF), 16);
    }

    protected String toStringOf(Integer i) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(i), 32);
    }

    @Override
    protected String toStringOf(Long l) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(l), 64);
    }

    @Override
    protected String toStringOf(Float f) {
        return BinaryRepresentation.toGroupedBinary(Integer.toBinaryString(Float.floatToIntBits(f.floatValue())), 32);
    }

    protected String toStringOf(Double d) {
        return BinaryRepresentation.toGroupedBinary(Long.toBinaryString(Double.doubleToRawLongBits(d)), 64);
    }

    @Override
    protected String toStringOf(Character character) {
        return Strings.concat("'", this.toStringOf((short)character.charValue()), "'");
    }

    private static String toGroupedBinary(String value, int size) {
        return BYTE_PREFIX + NumberGrouping.toBinaryLiteral(BinaryRepresentation.toBinary(value, size));
    }

    private static String toBinary(String value, int size) {
        return String.format("%" + size + "s", value).replace(' ', '0');
    }
}

