/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.handler.unified;

import com.intellij.debugger.streams.core.trace.dsl.Dsl;
import com.intellij.debugger.streams.core.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.core.trace.impl.handler.unified.PeekTraceHandler;
import com.intellij.debugger.streams.core.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.core.wrapper.impl.IntermediateStreamCallImpl;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/streams/trace/impl/handler/unified/ParallelHandler;", "Lcom/intellij/debugger/streams/core/trace/impl/handler/unified/PeekTraceHandler;", "num", "", "call", "Lcom/intellij/debugger/streams/core/wrapper/IntermediateStreamCall;", "dsl", "Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;", "<init>", "(ILcom/intellij/debugger/streams/core/wrapper/IntermediateStreamCall;Lcom/intellij/debugger/streams/core/trace/dsl/Dsl;)V", "additionalCallsAfter", "", "SequentialCall", "intellij.java.debugger.streams"})
public final class ParallelHandler
extends PeekTraceHandler {
    @NotNull
    private final IntermediateStreamCall call;

    public ParallelHandler(int num, @NotNull IntermediateStreamCall call, @NotNull Dsl dsl) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)dsl, (String)"dsl");
        String string = call.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        GenericType genericType = call.getTypeBefore();
        Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getTypeBefore(...)");
        GenericType genericType2 = call.getTypeAfter();
        Intrinsics.checkNotNullExpressionValue((Object)genericType2, (String)"getTypeAfter(...)");
        super(num, string, genericType, genericType2, dsl);
        this.call = call;
    }

    @NotNull
    public List<IntermediateStreamCall> additionalCallsAfter() {
        ArrayList<SequentialCall> calls = new ArrayList<SequentialCall>(super.additionalCallsAfter());
        GenericType genericType = this.call.getTypeBefore();
        Intrinsics.checkNotNullExpressionValue((Object)genericType, (String)"getTypeBefore(...)");
        calls.add(0, new SequentialCall(genericType));
        return calls;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/debugger/streams/trace/impl/handler/unified/ParallelHandler$SequentialCall;", "Lcom/intellij/debugger/streams/core/wrapper/impl/IntermediateStreamCallImpl;", "elementsType", "Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;", "<init>", "(Lcom/intellij/debugger/streams/core/trace/impl/handler/type/GenericType;)V", "intellij.java.debugger.streams"})
    private static final class SequentialCall
    extends IntermediateStreamCallImpl {
        public SequentialCall(@NotNull GenericType elementsType) {
            Intrinsics.checkNotNullParameter((Object)elementsType, (String)"elementsType");
            super("sequential", "", CollectionsKt.emptyList(), elementsType, elementsType, TextRange.EMPTY_RANGE);
        }
    }
}

