/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class CheckinHandler {
    public static final CheckinHandler DUMMY = new CheckinHandler(){};

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        return null;
    }

    @Nullable
    public UnnamedConfigurable getBeforeCheckinSettings() {
        return (UnnamedConfigurable)ObjectUtils.tryCast((Object)this.getBeforeCheckinConfigurationPanel(), UnnamedConfigurable.class);
    }

    @Nullable
    public RefreshableOnComponent getAfterCheckinConfigurationPanel(Disposable parentDisposable) {
        return null;
    }

    @Nullable
    public ReturnResult beforeCheckin(@Nullable CommitExecutor executor, PairConsumer<Object, Object> additionalDataConsumer) {
        return this.beforeCheckin();
    }

    public ReturnResult beforeCheckin() {
        return ReturnResult.COMMIT;
    }

    @RequiresEdt
    public void checkinSuccessful() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    public void checkinFailed(List<VcsException> exception) {
    }

    public void includedChangesChanged() {
    }

    public boolean acceptExecutor(CommitExecutor executor) {
        return !(executor instanceof LocalCommitExecutor);
    }

    public static enum ReturnResult {
        COMMIT,
        CANCEL,
        CLOSE_WINDOW;

    }
}

