/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.presentation;

import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomGoals;

public class MavenGoalsPresentationProvider
extends PresentationProvider<MavenDomGoals> {
    @Nullable
    public String getName(MavenDomGoals mavenDomGoals) {
        StringBuilder res = new StringBuilder("Goals");
        boolean hasGoals = false;
        for (MavenDomGoal mavenDomGoal : mavenDomGoals.getGoals()) {
            String goal = mavenDomGoal.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)goal)) continue;
            if (hasGoals) {
                res.append(", ");
            } else {
                res.append(" (");
                hasGoals = true;
            }
            res.append(goal);
        }
        if (hasGoals) {
            res.append(")");
        }
        return res.toString();
    }
}

