/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.rollover.RolloverProducer;

public class TreeRolloverProducer
extends RolloverProducer {
    @Override
    public void mousePressed(MouseEvent e2) {
        JXTree tree = (JXTree)e2.getComponent();
        Point mousePoint = e2.getPoint();
        int labelRow = tree.getRowForLocation(mousePoint.x, mousePoint.y);
        if (labelRow >= 0) {
            return;
        }
        int row = tree.getClosestRowForLocation(mousePoint.x, mousePoint.y);
        Rectangle bounds = tree.getRowBounds(row);
        if (bounds == null) {
            row = -1;
        } else if (bounds.y + bounds.height < mousePoint.y || bounds.x > mousePoint.x) {
            row = -1;
        }
        if (row < 0) {
            return;
        }
        tree.dispatchEvent(new MouseEvent(tree, e2.getID(), e2.getWhen(), e2.getModifiers(), bounds.x + bounds.width - 2, mousePoint.y, e2.getClickCount(), e2.isPopupTrigger(), e2.getButton()));
    }

    @Override
    protected void updateRolloverPoint(JComponent component, Point mousePoint) {
        int col;
        JXTree tree = (JXTree)component;
        int row = tree.getClosestRowForLocation(mousePoint.x, mousePoint.y);
        Rectangle bounds = tree.getRowBounds(row);
        if (bounds == null) {
            row = -1;
        } else if (bounds.y + bounds.height < mousePoint.y || bounds.x > mousePoint.x) {
            row = -1;
        }
        this.rollover.x = col = row < 0 ? -1 : 0;
        this.rollover.y = row;
    }
}

