/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.TypeOrElementOrAttributeReference;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSchemaPrefixIntention
extends PsiElementBaseIntentionAction {
    public AddSchemaPrefixIntention() {
        this.setText(XmlBundle.message("xml.intention.insert.namespace.prefix.name", new Object[0]));
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(final @NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        XmlAttribute xmlns;
        if (project == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(2);
        }
        if ((xmlns = AddSchemaPrefixIntention.getXmlnsDeclaration(element)) == null) {
            return;
        }
        final String namespace = xmlns.getValue();
        XmlTag tag = xmlns.getParent();
        if (tag != null) {
            final Set ns = tag.getLocalNamespaceDeclarations().keySet();
            String nsPrefix = Messages.showInputDialog((Project)project, (String)XmlBundle.message("namespace.prefix", new Object[0]), (String)XmlBundle.message("xml.intention.insert.namespace.prefix.command", new Object[0]), (Icon)Messages.getInformationIcon(), (String)"", (InputValidator)new InputValidator(){

                public boolean checkInput(String inputString) {
                    return !ns.contains(inputString) && AddSchemaPrefixIntention.isValidPrefix(inputString, project);
                }

                public boolean canClose(String inputString) {
                    return this.checkInput(inputString);
                }
            });
            if (nsPrefix == null) {
                return;
            }
            final ArrayList tags = new ArrayList();
            final ArrayList values = new ArrayList();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{tag.getContainingFile()}).withName(XmlBundle.message("xml.intention.insert.namespace.prefix.command", new Object[0])).run(() -> {
                tag.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(this){

                    public void visitXmlTag(@NotNull XmlTag tag) {
                        if (tag == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (tag.getNamespace().equals(namespace) && tag.getNamespacePrefix().isEmpty()) {
                            tags.add(tag);
                        }
                        super.visitXmlTag(tag);
                    }

                    public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
                        XmlTag tag;
                        PsiElement xmlElement;
                        if (value == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        PsiReference ref = null;
                        boolean skip = false;
                        for (PsiReference reference : value.getReferences()) {
                            if (reference instanceof TypeOrElementOrAttributeReference) {
                                ref = reference;
                                continue;
                            }
                            if (!(reference instanceof SchemaPrefixReference)) continue;
                            skip = true;
                            break;
                        }
                        if (!skip && ref != null && (xmlElement = ref.resolve()) instanceof XmlElement && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlElement, XmlTag.class, (boolean)false)) != null && tag.getNamespace().equals(namespace) && ref.getRangeInElement().getLength() == value.getValue().length()) {
                            values.add(value);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "tag";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "value";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention$2";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitXmlTag";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitXmlAttributeValue";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                for (XmlAttributeValue value : values) {
                    ((XmlAttribute)value.getParent()).setValue(nsPrefix + ":" + value.getValue());
                }
                for (XmlTag xmlTag : tags) {
                    xmlTag.setName(nsPrefix + ":" + xmlTag.getLocalName());
                }
                xmlns.setName("xmlns:" + nsPrefix);
            });
        }
    }

    private static boolean isValidPrefix(String prefix, Project project) {
        try {
            XmlTag tag = XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)("<" + prefix + ":foo/>"));
            return "foo".equals(tag.getLocalName());
        }
        catch (IncorrectOperationException e) {
            return false;
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            AddSchemaPrefixIntention.$$$reportNull$$$0(4);
        }
        return AddSchemaPrefixIntention.getXmlnsDeclaration(element) != null;
    }

    @Nullable
    private static XmlAttribute getXmlnsDeclaration(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof XmlTag) {
            XmlTag tag = (XmlTag)parent;
            if (tag.getNamespacePrefix().isEmpty()) {
                while (tag != null) {
                    XmlAttribute attr = tag.getAttribute("xmlns");
                    if (attr != null) {
                        return attr;
                    }
                    tag = tag.getParentTag();
                }
            }
        } else if (parent instanceof XmlAttribute && ((XmlAttribute)parent).getName().equals("xmlns")) {
            return (XmlAttribute)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AddSchemaPrefixIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

